/*
 * Decompiled with CFR 0.152.
 */
package me.syntaxjason;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import me.syntaxjason.SyntObject;

public class SyntConf {
    private HashMap<String, Object> tmp = new HashMap();
    private final File file;
    private final String path;
    private final String name;

    public SyntConf(String path, String name) {
        this.path = path;
        this.name = name;
        this.file = new File(path, name + ".syntconf");
        if (!this.file.exists()) {
            try {
                this.file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return;
        }
        try {
            this.load();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public SyntConf(File file) {
        this.file = file;
        this.path = file.getAbsolutePath();
        this.name = file.getName();
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return;
        }
        try {
            this.load();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void save() throws IOException {
        if (this.tmp == null) {
            throw new NullPointerException("You have to load the configuration first:\n");
        }
        if (this.tmp.isEmpty()) {
            Logger.getAnonymousLogger().warning("Temp Cache is empty!");
            return;
        }
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(this.file));){
            for (Map.Entry<String, Object> entry : this.tmp.entrySet()) {
                writer.write(entry.getKey() + "->");
                Object value = entry.getValue();
                if (value instanceof List) {
                    this.writeList(writer, (List)value);
                    continue;
                }
                if (value instanceof Map) {
                    this.writeMap(writer, (Map)value);
                    continue;
                }
                writer.write(value.toString() + "\n");
            }
        }
    }

    private void writeList(BufferedWriter writer, List<?> list) throws IOException {
        writer.write("/{");
        for (int i = 0; i < list.size(); ++i) {
            writer.write(String.valueOf(list.get(i)));
            if (i >= list.size() - 1) continue;
            writer.write(", ");
        }
        writer.write("}\\\n");
    }

    private void writeMap(BufferedWriter writer, Map<?, ?> map) throws IOException {
        writer.write("{/");
        int count = 0;
        for (Map.Entry<?, ?> mapEntry : map.entrySet()) {
            writer.write(String.valueOf(mapEntry.getKey()) + ":" + String.valueOf(mapEntry.getValue()));
            if (count < map.size() - 1) {
                writer.write(", ");
            }
            ++count;
        }
        writer.write("}\\\n");
    }

    public void addValue(String key, Object value) {
        if (this.tmp == null) {
            throw new NullPointerException("You have to load the configuration first:\n");
        }
        if (this.tmp.containsKey(key)) {
            throw new IllegalArgumentException("The value is already in the cache:\n");
        }
        this.tmp.put(key, value);
        try {
            this.save();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void removeValue(String key, Object value) {
        if (this.tmp == null) {
            throw new NullPointerException("You have to load the configuration first:\n");
        }
        if (!this.tmp.containsKey(key)) {
            throw new IllegalArgumentException("The value is not in the cache:\n");
        }
        if (!this.tmp.get(key).equals(value)) {
            throw new NullPointerException("This key does not have the value:\n");
        }
        this.tmp.remove(key, value);
        try {
            this.save();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void removeValue(String key) {
        if (this.tmp == null) {
            throw new NullPointerException("You have to load the configuration first:\n");
        }
        if (!this.tmp.containsKey(key)) {
            throw new IllegalArgumentException("The value is not in the cache:\n");
        }
        this.tmp.remove(key);
        try {
            this.save();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean containsKey(String key) {
        if (this.tmp == null) {
            throw new NullPointerException("You have to load the configuration first:\n");
        }
        return this.tmp.containsKey(key);
    }

    public SyntObject getValue(String key) {
        if (this.tmp == null) {
            throw new NullPointerException("You have to load the configuration first:\n");
        }
        if (!this.tmp.containsKey(key)) {
            throw new IllegalArgumentException("The value is not in the cache:\n");
        }
        return new SyntObject(this.tmp.get(key));
    }

    public void load() throws IOException {
        this.tmp = new HashMap();
        if (!this.file.exists()) {
            return;
        }
        try (BufferedReader reader = new BufferedReader(new FileReader(this.file));){
            String line;
            while ((line = reader.readLine()) != null) {
                int arrowIndex = line.indexOf("->");
                if (arrowIndex == -1) continue;
                String pathName = line.substring(0, arrowIndex);
                String dataString = line.substring(arrowIndex + 2);
                if (dataString.startsWith("/{")) {
                    this.loadList(pathName, dataString);
                    continue;
                }
                if (dataString.startsWith("{/")) {
                    this.loadMap(pathName, dataString);
                    continue;
                }
                this.tmp.put(pathName, dataString);
            }
        }
    }

    private void loadList(String pathName, String dataString) {
        dataString = dataString.substring(2, dataString.length() - 2);
        String[] dataItems = dataString.split(", ");
        ArrayList<String> dataList = new ArrayList<String>();
        for (String item : dataItems) {
            dataList.add(item);
        }
        this.tmp.put(pathName, dataList);
    }

    private void loadMap(String pathName, String dataString) {
        String[] entries;
        dataString = dataString.substring(2, dataString.length() - 2);
        HashMap<String, String> map = new HashMap<String, String>();
        for (String entry : entries = dataString.split(", ")) {
            String[] keyValue = entry.split(":");
            if (keyValue.length != 2) continue;
            map.put(keyValue[0], keyValue[1]);
        }
        this.tmp.put(pathName, map);
    }

    public File getFile() {
        return this.file;
    }

    public String getPath() {
        return this.path;
    }

    public String getName() {
        return this.name;
    }
}

