/*
 * Decompiled with CFR 0.152.
 */
package me.lauriichan.laylib.reflection;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Optional;
import me.lauriichan.laylib.reflection.ClassUtil;
import me.lauriichan.laylib.reflection.StackTracker;
import sun.misc.Unsafe;

public final class JavaAccess {
    private static final JavaAccess INSTANCE = new JavaAccess();
    private Unsafe unsafe;
    private MethodHandles.Lookup lookup;

    private JavaAccess() {
        Optional<Class<?>> option = StackTracker.getCallerClass();
        if (!option.isPresent() || option.get() != JavaAccess.class) {
            throw new UnsupportedOperationException("Utility class");
        }
    }

    public Unsafe unsafe() {
        if (this.unsafe != null) {
            return this.unsafe;
        }
        try {
            Field field = Unsafe.class.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            this.unsafe = (Unsafe)field.get(null);
            return this.unsafe;
        }
        catch (Exception exp) {
            return null;
        }
    }

    public MethodHandles.Lookup lookup() {
        if (this.lookup != null) {
            return this.lookup;
        }
        this.lookup = (MethodHandles.Lookup)this.getStaticValueUnsafe(ClassUtil.getField(MethodHandles.Lookup.class, "IMPL_LOOKUP"));
        return this.lookup;
    }

    public Object execute(Object instance, Method method, Object ... arguments) {
        if (method == null || method.getParameterCount() != arguments.length) {
            return null;
        }
        try {
            return this.executeThrows(instance, method, arguments);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public Object executeThrows(Object instance, Method method, Object ... arguments) throws Throwable {
        if (method == null || method.getParameterCount() != arguments.length) {
            return null;
        }
        if (!Modifier.isStatic(method.getModifiers())) {
            if (instance == null) {
                return null;
            }
            if (arguments.length == 0) {
                return this.lookup().unreflect(method).invokeWithArguments(instance);
            }
            Object[] input = new Object[arguments.length + 1];
            input[0] = instance;
            System.arraycopy(arguments, 0, input, 1, arguments.length);
            return this.lookup().unreflect(method).invokeWithArguments(input);
        }
        return this.lookup().unreflect(method).invokeWithArguments(arguments);
    }

    public Object init(Constructor<?> constructor, Object ... arguments) {
        if (constructor == null || constructor.getParameterCount() != arguments.length) {
            return null;
        }
        try {
            return this.lookup().unreflectConstructor(constructor).invokeWithArguments(arguments);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public Object initThrows(Constructor<?> constructor, Object ... arguments) throws Throwable {
        if (constructor == null || constructor.getParameterCount() != arguments.length) {
            return null;
        }
        return this.lookup().unreflectConstructor(constructor).invokeWithArguments(arguments);
    }

    public VarHandle handle(Field field, boolean force) {
        if (field == null) {
            return null;
        }
        if (force) {
            this.unfinalize(field);
        }
        try {
            return this.lookup().unreflectVarHandle(field);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public MethodHandle handleGetter(Field field) {
        if (field == null) {
            return null;
        }
        try {
            return this.lookup().unreflectGetter(field);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public MethodHandle handleSetter(Field field) {
        if (field == null) {
            return null;
        }
        this.unfinalize(field);
        try {
            return this.lookup().unreflectSetter(field);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public MethodHandle handle(Method method) {
        if (method == null) {
            return null;
        }
        try {
            return this.lookup().unreflect(method);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public MethodHandle handle(Constructor<?> constructor) {
        if (constructor == null) {
            return null;
        }
        try {
            return this.lookup().unreflectConstructor(constructor);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public Object executeSafe(Object instance, MethodHandle handle, Object ... arguments) {
        if (handle == null || handle.type().parameterCount() != arguments.length) {
            return null;
        }
        try {
            if (instance != null) {
                if (arguments.length == 0) {
                    return handle.invokeWithArguments(instance);
                }
                Object[] input = new Object[arguments.length + 1];
                input[0] = instance;
                System.arraycopy(arguments, 0, input, 1, arguments.length);
                return handle.invokeWithArguments(input);
            }
            return handle.invokeWithArguments(arguments);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public Object getValueSafe(Object instance, VarHandle handle) {
        if (handle == null) {
            return null;
        }
        try {
            if (instance == null) {
                return handle.getVolatile();
            }
            return handle.getVolatile(instance);
        }
        catch (Throwable e) {
            throw new AccessUnsuccessful();
        }
    }

    public void setValueSafe(Object instance, VarHandle handle, Object value) {
        if (handle == null || value != null && !handle.varType().isAssignableFrom(value.getClass())) {
            return;
        }
        try {
            if (instance != null) {
                handle.setVolatile(value);
                return;
            }
            handle.setVolatile(instance, value);
        }
        catch (Throwable e) {
            throw new AccessUnsuccessful();
        }
    }

    public Object getObjectValueSafe(Object instance, Field field) {
        if (instance == null || field == null) {
            return null;
        }
        try {
            return this.lookup().unreflectVarHandle(field).get(instance);
        }
        catch (Throwable e) {
            throw new AccessUnsuccessful();
        }
    }

    public Object getStaticValueSafe(Field field) {
        if (field == null) {
            return null;
        }
        try {
            return this.lookup().unreflectVarHandle(field).get();
        }
        catch (Throwable e) {
            throw new AccessUnsuccessful();
        }
    }

    public void setObjectValueSafe(Object instance, Field field, Object value) {
        if (instance == null || field == null) {
            return;
        }
        this.unfinalize(field);
        try {
            this.lookup().unreflectVarHandle(field).set(instance, value);
        }
        catch (Throwable e) {
            throw new AccessUnsuccessful();
        }
    }

    public void setStaticValueSafe(Field field, Object value) {
        if (field == null) {
            return;
        }
        this.unfinalize(field);
        try {
            this.lookup().unreflectVarHandle(field).set(value);
        }
        catch (Throwable e) {
            throw new AccessUnsuccessful();
        }
    }

    public Object getObjectValueUnsafe(Object instance, Field field) {
        if (instance == null || field == null) {
            return null;
        }
        Unsafe unsafe = this.unsafe();
        return unsafe.getObjectVolatile(instance, unsafe.objectFieldOffset(field));
    }

    public Object getStaticValueUnsafe(Field field) {
        if (field == null) {
            return null;
        }
        Unsafe unsafe = this.unsafe();
        return unsafe.getObjectVolatile(unsafe.staticFieldBase(field), unsafe.staticFieldOffset(field));
    }

    public void setObjectValueUnsafe(Object instance, Field field, Object value) {
        if (instance == null || field == null) {
            return;
        }
        this.unfinalize(field);
        Unsafe unsafe = this.unsafe();
        if (value == null) {
            unsafe.putObject(instance, unsafe.objectFieldOffset(field), null);
            return;
        }
        unsafe.putObject(instance, unsafe.objectFieldOffset(field), field.getType().cast(value));
    }

    public void setStaticValueUnsafe(Field field, Object value) {
        if (field == null) {
            return;
        }
        this.unfinalize(field);
        Unsafe unsafe = this.unsafe();
        if (value == null) {
            unsafe.putObject(unsafe.staticFieldBase(field), unsafe.staticFieldOffset(field), null);
            return;
        }
        unsafe.putObject(unsafe.staticFieldBase(field), unsafe.staticFieldOffset(field), field.getType().cast(value));
    }

    private void unfinalize(Field field) {
        if (!Modifier.isFinal(field.getModifiers())) {
            return;
        }
        try {
            this.lookup().findSetter(Field.class, "modifiers", Integer.TYPE).invokeExact(field, field.getModifiers() & 0xFFFFFFEF);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static Object getStaticValue(VarHandle handle) {
        return INSTANCE.getValueSafe(null, handle);
    }

    public static Object getValue(Object instance, VarHandle handle) {
        return INSTANCE.getValueSafe(instance, handle);
    }

    public static void setStaticValue(VarHandle handle, Object value) {
        INSTANCE.setValueSafe(null, handle, value);
    }

    public static void setValue(Object instance, VarHandle handle, Object value) {
        INSTANCE.setValueSafe(instance, handle, value);
    }

    public static Object invokeStatic(MethodHandle handle, Object ... arguments) {
        return INSTANCE.executeSafe(null, handle, arguments);
    }

    public static Object invoke(Object instance, MethodHandle handle, Object ... arguments) {
        return INSTANCE.executeSafe(instance, handle, arguments);
    }

    public static Object instance(Class<?> clazz) {
        return INSTANCE.init(ClassUtil.getConstructor(clazz, new Class[0]), new Object[0]);
    }

    public static Object instance(Constructor<?> constructor, Object ... arguments) {
        return INSTANCE.init(constructor, arguments);
    }

    public static Object instanceThrows(Class<?> clazz) throws Throwable {
        return INSTANCE.initThrows(ClassUtil.getConstructor(clazz, new Class[0]), new Object[0]);
    }

    public static Object instanceThrows(Constructor<?> constructor, Object ... arguments) throws Throwable {
        return INSTANCE.initThrows(constructor, arguments);
    }

    public static Object invokeStatic(Method method, Object ... arguments) {
        return INSTANCE.execute(null, method, arguments);
    }

    public static Object invoke(Object instance, Method method, Object ... arguments) {
        return INSTANCE.execute(instance, method, arguments);
    }

    public static Object invokeThrows(Object instance, Method method, Object ... arguments) throws Throwable {
        return INSTANCE.executeThrows(instance, method, arguments);
    }

    public static void setValue(Object instance, Class<?> clazz, String fieldName, Object value) {
        JavaAccess.setValue(instance, ClassUtil.getField(clazz, fieldName), value);
    }

    public static void setObjectValue(Object instance, Class<?> clazz, String fieldName, Object value) {
        JavaAccess.setObjectValue(instance, ClassUtil.getField(clazz, fieldName), value);
    }

    public static void setStaticValue(Class<?> clazz, String fieldName, Object value) {
        JavaAccess.setStaticValue(ClassUtil.getField(clazz, fieldName), value);
    }

    public static void setValue(Object instance, Field field, Object value) {
        if (field == null) {
            return;
        }
        if (Modifier.isStatic(field.getModifiers())) {
            JavaAccess.setStaticValue(field, value);
            return;
        }
        JavaAccess.setObjectValue(instance, field, value);
    }

    public static void setObjectValue(Object instance, Field field, Object value) {
        if (instance == null || field == null) {
            return;
        }
        try {
            INSTANCE.setObjectValueSafe(instance, field, value);
        }
        catch (AccessUnsuccessful unsafe) {
            INSTANCE.setObjectValueUnsafe(instance, field, value);
        }
    }

    public static void setStaticValue(Field field, Object value) {
        if (field == null) {
            return;
        }
        try {
            INSTANCE.setStaticValueSafe(field, value);
        }
        catch (AccessUnsuccessful unsafe) {
            INSTANCE.setStaticValueUnsafe(field, value);
        }
    }

    public static Object getValue(Object instance, Class<?> clazz, String fieldName) {
        return JavaAccess.getValue(instance, ClassUtil.getField(clazz, fieldName));
    }

    public static Object getObjectValue(Object instance, Class<?> clazz, String fieldName) {
        return JavaAccess.getObjectValue(instance, ClassUtil.getField(clazz, fieldName));
    }

    public static Object getStaticValue(Class<?> clazz, String fieldName) {
        return JavaAccess.getStaticValue(ClassUtil.getField(clazz, fieldName));
    }

    public static Object getValue(Object instance, Field field) {
        if (field == null) {
            return null;
        }
        if (Modifier.isStatic(field.getModifiers())) {
            return JavaAccess.getStaticValue(field);
        }
        return JavaAccess.getObjectValue(instance, field);
    }

    public static Object getObjectValue(Object instance, Field field) {
        if (instance == null || field == null) {
            return null;
        }
        try {
            return INSTANCE.getObjectValueSafe(instance, field);
        }
        catch (AccessUnsuccessful unsafe) {
            return INSTANCE.getObjectValueUnsafe(instance, field);
        }
    }

    public static Object getStaticValue(Field field) {
        if (field == null) {
            return null;
        }
        try {
            return INSTANCE.getStaticValueSafe(field);
        }
        catch (AccessUnsuccessful unsafe) {
            return INSTANCE.getStaticValueUnsafe(field);
        }
    }

    public static VarHandle accessField(Field field) {
        return INSTANCE.handle(field, false);
    }

    public static VarHandle accessField(Field field, boolean forceModification) {
        return INSTANCE.handle(field, forceModification);
    }

    public static MethodHandle accessFieldGetter(Field field) {
        return INSTANCE.handleGetter(field);
    }

    public static MethodHandle accessFieldSetter(Field field) {
        return INSTANCE.handleSetter(field);
    }

    public static MethodHandle accessMethod(Method method) {
        return INSTANCE.handle(method);
    }

    public static MethodHandle accessConstructor(Constructor<?> constructor) {
        return INSTANCE.handle(constructor);
    }

    private static final class AccessUnsuccessful
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        private AccessUnsuccessful() {
        }
    }
}

