/*
 * Decompiled with CFR 0.152.
 */
package me.lauriichan.laylib.reflection;

import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import me.lauriichan.laylib.reflection.Accessor;
import me.lauriichan.laylib.reflection.AccessorProvider;

final class AccessorCache {
    private final ConcurrentHashMap<Class<?>, Accessor> accessors = new ConcurrentHashMap();
    private final ArrayList<AccessorProvider> providers = new ArrayList();

    AccessorCache() {
    }

    final void listen(AccessorProvider provider) {
        if (this.providers.contains(provider)) {
            this.providers.remove(provider);
            return;
        }
        this.providers.add(provider);
    }

    public final Accessor get(Class<?> owner) {
        if (owner == null) {
            return null;
        }
        Accessor access = this.accessors.get(owner);
        if (access != null) {
            return access;
        }
        access = new Accessor(owner);
        this.accessors.put(owner, access);
        return access;
    }

    public final void delete(Class<?> owner) {
        this.accessors.remove(owner);
        for (AccessorProvider provider : this.providers) {
            provider.remove(owner);
        }
    }

    public final void clear(ClassLoader loader) {
        ArrayList<Class> classes = new ArrayList<Class>();
        for (Class clazz : this.accessors.keySet()) {
            if (!clazz.getClassLoader().equals(loader)) continue;
            classes.add(clazz);
        }
        for (Class clazz : classes) {
            this.accessors.remove(clazz);
            for (AccessorProvider provider : this.providers) {
                provider.remove(clazz);
            }
        }
    }

    public final void clear() {
        this.accessors.clear();
        for (AccessorProvider provider : this.providers) {
            provider.clear();
        }
    }
}

