/*
 * Decompiled with CFR 0.152.
 */
package me.lauriichan.laylib.reflection;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import me.lauriichan.laylib.reflection.AccessorCache;
import me.lauriichan.laylib.reflection.ClassUtil;
import me.lauriichan.laylib.reflection.InstanceBuilder;
import me.lauriichan.laylib.reflection.JavaAccess;

public final class Accessor {
    public static final Accessor INVALID = new Accessor();
    static final AccessorCache CACHE = new AccessorCache();
    private final Class<?> owner;
    private final ConcurrentHashMap<String, Method> methods = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Field> fields = new ConcurrentHashMap();

    public static Accessor of(Class<?> owner) {
        return CACHE.get(owner);
    }

    public static Accessor ofNullable(Class<?> owner) {
        if (owner == null) {
            return INVALID;
        }
        return CACHE.get(owner);
    }

    private Accessor() {
        this.owner = null;
    }

    Accessor(Class<?> owner) {
        this.owner = Objects.requireNonNull(owner);
    }

    public boolean valid() {
        return this.owner != null;
    }

    public void delete() {
        if (this.valid()) {
            CACHE.delete(this.owner);
        }
        this.clear();
    }

    public Class<?> getOwner() {
        return this.owner;
    }

    public Collection<Method> getMethods() {
        return this.methods.values();
    }

    public Collection<Field> getFields() {
        return this.fields.values();
    }

    public List<Method> getMethods(String baseName) {
        String name;
        String base = baseName + "#";
        int index = 0;
        ArrayList<Method> methods = new ArrayList<Method>();
        while (this.methods.containsKey(name = base + index++)) {
            methods.add(this.methods.get(name));
        }
        return methods;
    }

    public List<Field> getFields(String baseName) {
        String name;
        String base = baseName + "#";
        int index = 0;
        ArrayList<Field> fields = new ArrayList<Field>();
        while (this.fields.containsKey(name = base + index++)) {
            fields.add(this.fields.get(name));
        }
        return fields;
    }

    public Method getMethod(String name) {
        return this.methods.get(name);
    }

    public Field getField(String name) {
        return this.fields.get(name);
    }

    public boolean hasMethod(String name) {
        return this.methods.containsKey(name);
    }

    public boolean hasField(String name) {
        return this.fields.containsKey(name);
    }

    public void putMethod(String name, Method method) {
        if (!this.valid() || this.methods.containsKey(name) || !method.getDeclaringClass().isAssignableFrom(this.owner)) {
            return;
        }
        this.methods.put(name, method);
    }

    public void putField(String name, Field field) {
        if (!this.valid() || this.fields.containsKey(name) || !field.getDeclaringClass().isAssignableFrom(this.owner)) {
            return;
        }
        this.fields.put(name, field);
    }

    public void removeMethod(String name) {
        this.methods.remove(name);
    }

    public void removeField(String name) {
        this.fields.remove(name);
    }

    public void clear() {
        this.methods.clear();
        this.fields.clear();
    }

    public void clearMethods() {
        this.methods.clear();
    }

    public void clearFields() {
        this.fields.clear();
    }

    public Class<?> findNestedClass(String name) {
        if (!this.valid()) {
            return null;
        }
        return ClassUtil.findClass(this.owner, name);
    }

    public Constructor<?> findConstructor(Class<?> ... parameters) {
        if (!this.valid()) {
            return null;
        }
        return ClassUtil.getConstructor(this.owner, parameters);
    }

    public Object initialize(Object ... arguments) {
        if (!this.valid()) {
            return null;
        }
        return InstanceBuilder.create(this.owner, arguments);
    }

    public Object getValue(String name) {
        return this.getValue(null, name);
    }

    public Object getValue(Object instance, String name) {
        Field field = this.fields.get(name);
        if (field == null) {
            return null;
        }
        if (Modifier.isStatic(field.getModifiers())) {
            return JavaAccess.getStaticValue(field);
        }
        if (instance == null) {
            return null;
        }
        return JavaAccess.getObjectValue(instance, this.fields.get(name));
    }

    public void setValue(String name, Object value) {
        this.setValue(null, name, value);
    }

    public void setValue(Object instance, String name, Object value) {
        Field field = this.fields.get(name);
        if (field == null) {
            return;
        }
        if (Modifier.isStatic(field.getModifiers())) {
            JavaAccess.setStaticValue(field, value);
            return;
        }
        if (instance == null) {
            return;
        }
        JavaAccess.setObjectValue(instance, field, value);
    }

    public Object invoke(String name, Object ... arguments) {
        return this.invoke((Object)null, name, arguments);
    }

    public Object invoke(Object instance, String name, Object ... arguments) {
        Method method = this.methods.get(name);
        if (method == null || method.getParameterCount() != arguments.length) {
            return null;
        }
        if (Modifier.isStatic(method.getModifiers())) {
            return JavaAccess.invokeStatic(method, arguments);
        }
        if (instance == null) {
            return null;
        }
        return JavaAccess.invoke(instance, method, arguments);
    }

    public Accessor findMethod(String name, String methodName, Class<?> ... parameters) {
        if (!this.valid() || this.methods.containsKey(name)) {
            return this;
        }
        Method method = ClassUtil.getMethod(this.owner, methodName, parameters);
        if (method != null) {
            this.methods.put(name, method);
        }
        return this;
    }

    public Accessor findMethod(String name, Class<?> ... parameters) {
        return this.findMethod(name, 0, parameters);
    }

    public Accessor findMethod(String name, int index, Class<?> ... parameters) {
        if (!this.valid() || this.methods.containsKey(name)) {
            return this;
        }
        Method[] methods = ClassUtil.getMethods(this.owner);
        if (methods.length == 0) {
            return this;
        }
        int idx = 0;
        for (Method method : methods) {
            Class<?>[] methodParameters = method.getParameterTypes();
            if (methodParameters.length != parameters.length || !Accessor.hasSameArguments(methodParameters, parameters) || idx++ != index) continue;
            this.methods.put(name, method);
        }
        return this;
    }

    public Accessor findMethods(String baseName, Class<?> ... parameters) {
        if (!this.valid()) {
            return this;
        }
        Method[] methods = ClassUtil.getMethods(this.owner);
        if (methods.length == 0) {
            return this;
        }
        String base = baseName + "#";
        int index = 0;
        for (Method method : methods) {
            String name;
            Class<?>[] methodParameters = method.getParameterTypes();
            if (methodParameters.length != parameters.length || !Accessor.hasSameArguments(methodParameters, parameters) || this.methods.containsKey(name = base + index++)) continue;
            this.methods.put(name, method);
        }
        return this;
    }

    public Accessor findField(String name, String fieldName) {
        if (!this.valid() || this.fields.containsKey(name)) {
            return this;
        }
        Field field = ClassUtil.getField(this.owner, fieldName);
        if (field != null) {
            this.fields.put(name, field);
        }
        return this;
    }

    public Accessor findField(String name, Class<?> type) {
        return this.findField(name, 0, type);
    }

    public Accessor findField(String name, int index, Class<?> type) {
        if (!this.valid() || this.fields.containsKey(name)) {
            return this;
        }
        Field[] fields = ClassUtil.getFields(this.owner);
        if (fields.length == 0) {
            return this;
        }
        int idx = 0;
        for (Field field : fields) {
            if (!field.getType().equals(type) || idx++ != index) continue;
            this.fields.put(name, field);
        }
        return this;
    }

    public Accessor findFields(String baseName, Class<?> type) {
        if (!this.valid()) {
            return this;
        }
        Field[] fields = ClassUtil.getFields(this.owner);
        if (fields.length == 0) {
            return this;
        }
        String base = baseName + "#";
        int index = 0;
        for (Field field : fields) {
            String name;
            if (!field.getType().equals(type) || this.fields.containsKey(name = base + index++)) continue;
            this.fields.put(name, field);
        }
        return this;
    }

    private static boolean hasSameArguments(Class<?>[] compare1, Class<?>[] compare2) {
        if (compare1.length == 0 && compare2.length == 0) {
            return true;
        }
        if (compare1.length != compare2.length) {
            return false;
        }
        for (Class<?> arg1 : compare1) {
            boolean found = true;
            for (Class<?> arg2 : compare2) {
                if (arg1.isAssignableFrom(arg2)) continue;
                found = false;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }
}

