/*
 * Decompiled with CFR 0.152.
 */
package me.lauriichan.laylib.reflection;

import java.lang.reflect.Constructor;
import me.lauriichan.laylib.reflection.ClassUtil;
import me.lauriichan.laylib.reflection.JavaAccess;

public final class InstanceBuilder {
    private InstanceBuilder() {
        throw new UnsupportedOperationException();
    }

    public static <T> T create(Class<T> clazz, Object ... arguments) {
        if (arguments.length == 0) {
            return clazz.cast(JavaAccess.instance(clazz));
        }
        Constructor<?>[] constructors = ClassUtil.getConstructors(clazz);
        Class[] classes = new Class[arguments.length];
        for (int index = 0; index < arguments.length; ++index) {
            classes[index] = arguments[index].getClass();
        }
        int max = classes.length;
        Constructor<?> builder = null;
        int args = 0;
        int[] argIdx = new int[max];
        for (Constructor<?> constructor : constructors) {
            int count = constructor.getParameterCount();
            if (count > max || count < args) continue;
            int[] tmpIdx = new int[max];
            for (int idx = 0; idx < max; ++idx) {
                tmpIdx[idx] = -1;
            }
            Class<?>[] types = constructor.getParameterTypes();
            int tmpArgs = 0;
            for (int index = 0; index < count; ++index) {
                for (int idx = 0; idx < max; ++idx) {
                    if (!types[index].isAssignableFrom(classes[idx])) continue;
                    tmpIdx[idx] = index;
                    ++tmpArgs;
                }
            }
            if (tmpArgs != count) continue;
            argIdx = tmpIdx;
            args = tmpArgs;
            builder = constructor;
        }
        if (builder == null) {
            return null;
        }
        if (args == 0) {
            return clazz.cast(JavaAccess.instance(builder, new Object[0]));
        }
        Object[] parameters = new Object[args];
        for (int idx = 0; idx < max; ++idx) {
            if (argIdx[idx] == -1) continue;
            parameters[argIdx[idx]] = arguments[idx];
        }
        return clazz.cast(JavaAccess.instance(builder, parameters));
    }

    public static <T> T createThrows(Class<T> clazz, Object ... arguments) throws Throwable {
        if (arguments.length == 0) {
            return clazz.cast(JavaAccess.instanceThrows(clazz));
        }
        Constructor<?>[] constructors = ClassUtil.getConstructors(clazz);
        Class[] classes = new Class[arguments.length];
        for (int index = 0; index < arguments.length; ++index) {
            classes[index] = arguments[index].getClass();
        }
        int max = classes.length;
        Constructor<?> builder = null;
        int args = 0;
        int[] argIdx = new int[max];
        for (Constructor<?> constructor : constructors) {
            int count = constructor.getParameterCount();
            if (count > max || count < args) continue;
            int[] tmpIdx = new int[max];
            for (int idx = 0; idx < max; ++idx) {
                tmpIdx[idx] = -1;
            }
            Class<?>[] types = constructor.getParameterTypes();
            int tmpArgs = 0;
            for (int index = 0; index < count; ++index) {
                for (int idx = 0; idx < max; ++idx) {
                    if (!types[index].isAssignableFrom(classes[idx])) continue;
                    tmpIdx[idx] = index;
                    ++tmpArgs;
                }
            }
            if (tmpArgs != count) continue;
            argIdx = tmpIdx;
            args = tmpArgs;
            builder = constructor;
        }
        if (builder == null) {
            return null;
        }
        if (args == 0) {
            return clazz.cast(JavaAccess.instanceThrows(builder, new Object[0]));
        }
        Object[] parameters = new Object[args];
        for (int idx = 0; idx < max; ++idx) {
            if (argIdx[idx] == -1) continue;
            parameters[argIdx[idx]] = arguments[idx];
        }
        return clazz.cast(JavaAccess.instanceThrows(builder, parameters));
    }
}

