/*
 * Decompiled with CFR 0.152.
 */
package me.lauriichan.laylib.reflection;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public final class ClassUtil {
    public static final Map<Class<?>, Class<?>> PRIMITIVE_TO_COMPLEX;
    public static final Map<Class<?>, Class<?>> COMPLEX_TO_PRIMITIVE;

    private ClassUtil() {
        throw new UnsupportedOperationException();
    }

    public static Class<?> asClass(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Class) {
            return (Class)object;
        }
        return object.getClass();
    }

    public static boolean isWrappedType(Class<?> type) {
        return PRIMITIVE_TO_COMPLEX.containsKey(type) || COMPLEX_TO_PRIMITIVE.containsKey(type);
    }

    public static boolean isWrappedObject(Object object) {
        return ClassUtil.isWrappedType(ClassUtil.asClass(object));
    }

    public static boolean isPrimitiveType(Class<?> type) {
        return PRIMITIVE_TO_COMPLEX.containsKey(type);
    }

    public static boolean isPrimitiveObject(Object object) {
        return ClassUtil.isPrimitiveType(ClassUtil.asClass(object));
    }

    public static boolean isComplexType(Class<?> type) {
        return COMPLEX_TO_PRIMITIVE.containsKey(type);
    }

    public static boolean isComplexObject(Object object) {
        return ClassUtil.isComplexType(ClassUtil.asClass(object));
    }

    public static Class<?> toComplexType(Class<?> type) {
        return PRIMITIVE_TO_COMPLEX.getOrDefault(type, type);
    }

    public static Class<?> toPrimitiveType(Class<?> type) {
        return COMPLEX_TO_PRIMITIVE.getOrDefault(type, type);
    }

    public static String getClassName(Class<?> clazz) {
        String name = clazz.getSimpleName();
        if (name.contains(".")) {
            return name.split("\\.")[0];
        }
        return name;
    }

    public static Field getField(Class<?> clazz, String field) {
        if (clazz == null || field == null) {
            return null;
        }
        try {
            return clazz.getDeclaredField(field);
        }
        catch (NoSuchFieldException | SecurityException ignore) {
            try {
                return clazz.getField(field);
            }
            catch (NoSuchFieldException | SecurityException ignore0) {
                return null;
            }
        }
    }

    public static Field[] getFields(Class<?> clazz) {
        Field[] field0 = clazz.getFields();
        Field[] field1 = clazz.getDeclaredFields();
        HashSet fields = new HashSet();
        Collections.addAll(fields, field0);
        Collections.addAll(fields, field1);
        return fields.toArray(new Field[fields.size()]);
    }

    public static Field getStaticField(Class<?> clazz, Class<?> returnType) {
        return ClassUtil.getField(clazz, true, returnType);
    }

    public static Field getDeclaredField(Class<?> clazz, Class<?> returnType) {
        return ClassUtil.getField(clazz, false, returnType);
    }

    public static Field getField(Class<?> clazz, boolean isStatic, Class<?> returnType) {
        Field[] fields;
        if (clazz == null) {
            return null;
        }
        for (Field field : fields = ClassUtil.getFields(clazz)) {
            if (Modifier.isStatic(field.getModifiers()) != isStatic || !field.getType().equals(returnType)) continue;
            return field;
        }
        return null;
    }

    public static Method getMethod(Class<?> clazz, String method, Class<?> ... arguments) {
        if (clazz == null || method == null) {
            return null;
        }
        try {
            return clazz.getDeclaredMethod(method, arguments);
        }
        catch (NoSuchMethodException | SecurityException ignore) {
            try {
                return clazz.getMethod(method, arguments);
            }
            catch (NoSuchMethodException | SecurityException ignore0) {
                return null;
            }
        }
    }

    public static Method[] getMethods(Class<?> clazz) {
        Method[] method0 = clazz.getMethods();
        Method[] method1 = clazz.getDeclaredMethods();
        HashSet methods = new HashSet();
        Collections.addAll(methods, method0);
        Collections.addAll(methods, method1);
        return methods.toArray(new Method[methods.size()]);
    }

    public static Method getDeclaredMethod(Class<?> clazz, Class<?> returnType, Class<?> ... arguments) {
        return ClassUtil.getMethod(clazz, false, returnType, Collections.emptyList(), arguments);
    }

    public static Method getDeclaredMethod(Class<?> clazz, Class<?> returnType, List<String> blacklisted, Class<?> ... arguments) {
        return ClassUtil.getMethod(clazz, false, returnType, blacklisted, arguments);
    }

    public static Method getStaticMethod(Class<?> clazz, Class<?> returnType, Class<?> ... arguments) {
        return ClassUtil.getMethod(clazz, true, returnType, Collections.emptyList(), arguments);
    }

    public static Method getStaticMethod(Class<?> clazz, Class<?> returnType, List<String> blacklisted, Class<?> ... arguments) {
        return ClassUtil.getMethod(clazz, true, returnType, blacklisted, arguments);
    }

    public static Method getMethod(Class<?> clazz, boolean isStatic, Class<?> returnType, List<String> blacklisted, Class<?> ... arguments) {
        Method[] methods;
        if (clazz == null) {
            return null;
        }
        block0: for (Method method : methods = ClassUtil.getMethods(clazz)) {
            Class<?>[] parameters;
            if (Modifier.isStatic(method.getModifiers()) != isStatic || !method.getReturnType().equals(returnType) || blacklisted.contains(method.getName()) || (parameters = method.getParameterTypes()).length != arguments.length) continue;
            for (int index = 0; index < parameters.length; ++index) {
                if (!parameters[index].isAssignableFrom(arguments[index])) continue block0;
            }
            return method;
        }
        return null;
    }

    public static Constructor<?> getConstructor(Class<?> clazz, Class<?> ... arguments) {
        if (clazz == null) {
            return null;
        }
        try {
            return clazz.getDeclaredConstructor(arguments);
        }
        catch (NoSuchMethodException | SecurityException ignore) {
            try {
                return clazz.getConstructor(arguments);
            }
            catch (NoSuchMethodException | SecurityException ignore0) {
                return null;
            }
        }
    }

    public static Constructor<?>[] getConstructors(Class<?> clazz) {
        Constructor<?>[] constructor0 = clazz.getConstructors();
        Constructor<?>[] constructor1 = clazz.getDeclaredConstructors();
        HashSet constructors = new HashSet();
        Collections.addAll(constructors, constructor0);
        Collections.addAll(constructors, constructor1);
        return constructors.toArray(new Constructor[constructors.size()]);
    }

    public static Class<?> findClass(String name) {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException | LinkageError e) {
            return null;
        }
    }

    public static Class<?> findClass(Class<?> clazz, String name) {
        if (clazz == null || name == null) {
            return null;
        }
        int size = clazz.getClasses().length + clazz.getDeclaredClasses().length;
        if (size == 0) {
            return null;
        }
        Class[] classes = new Class[size];
        Class<?>[] tmp = clazz.getClasses();
        System.arraycopy(tmp, 0, classes, 0, tmp.length);
        System.arraycopy(clazz.getDeclaredClasses(), tmp.length, classes, tmp.length, size - tmp.length);
        for (int i = 0; i < size; ++i) {
            String target = classes[i].getSimpleName();
            if (target.contains(".")) {
                target = target.split(".", 2)[0];
            }
            if (!target.equals(name)) continue;
            return classes[i];
        }
        return null;
    }

    public static boolean hasAnnotation(AnnotatedElement element, Class<? extends Annotation> annotationType) {
        return element.isAnnotationPresent(annotationType);
    }

    public static <A extends Annotation> A getAnnotation(AnnotatedElement element, Class<A> annotationType) {
        A annotation = element.getAnnotation(annotationType);
        if (annotation != null) {
            return annotation;
        }
        return element.getDeclaredAnnotation(annotationType);
    }

    public static <A extends Annotation> A[] getAnnotations(AnnotatedElement element, Class<A> annotationType) {
        Annotation[] annotation0 = element.getAnnotationsByType(annotationType);
        Annotation[] annotation1 = element.getDeclaredAnnotationsByType(annotationType);
        if (annotation0.length != 0 && annotation1.length != 0) {
            HashSet annotations = new HashSet();
            Collections.addAll(annotations, annotation0);
            Collections.addAll(annotations, annotation1);
            return annotations.toArray((Annotation[])Array.newInstance(annotationType, annotations.size()));
        }
        if (annotation0.length == 0) {
            return annotation1;
        }
        return annotation0;
    }

    public static <A extends Annotation> Optional<A> getOptionalAnnotation(AnnotatedElement element, Class<A> annotationType) {
        return Optional.ofNullable(ClassUtil.getAnnotation(element, annotationType));
    }

    public static <E extends Throwable> Optional<E> findException(Throwable throwable, Class<E> type) {
        for (Throwable current = throwable; current != null; current = current.getCause()) {
            if (!type.isAssignableFrom(current.getClass())) continue;
            return Optional.of((Throwable)type.cast(current));
        }
        return Optional.empty();
    }

    static {
        HashMap collect = new HashMap(10);
        collect.put(Byte.TYPE, Byte.class);
        collect.put(Boolean.TYPE, Boolean.class);
        collect.put(Short.TYPE, Short.class);
        collect.put(Integer.TYPE, Integer.class);
        collect.put(Long.TYPE, Long.class);
        collect.put(Float.TYPE, Float.class);
        collect.put(Double.TYPE, Double.class);
        collect.put(String.class, String.class);
        collect.put(Void.TYPE, Void.class);
        collect.put(Character.TYPE, Character.class);
        PRIMITIVE_TO_COMPLEX = Collections.unmodifiableMap(collect);
        collect = new HashMap(10);
        for (Map.Entry<Class<?>, Class<?>> entry : PRIMITIVE_TO_COMPLEX.entrySet()) {
            collect.put(entry.getValue(), entry.getKey());
        }
        COMPLEX_TO_PRIMITIVE = Collections.unmodifiableMap(collect);
    }
}

