/*
 * Decompiled with CFR 0.152.
 */
package me.lauriichan.laylib.reflection;

import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import me.lauriichan.laylib.reflection.Accessor;

public final class AccessorProvider {
    private boolean deleted = false;
    private final ConcurrentHashMap<Class<?>, String> names = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Accessor> accessors = new ConcurrentHashMap();

    public AccessorProvider() {
        Accessor.CACHE.listen(this);
    }

    public void delete() {
        if (this.deleted) {
            return;
        }
        this.deleted = true;
        Accessor.CACHE.listen(this);
        this.clear();
    }

    public Optional<Accessor> get(String name) {
        return Optional.ofNullable(this.accessors.get(name));
    }

    public Accessor getOrNull(String name) {
        return this.accessors.get(name);
    }

    public Accessor create(String name, Class<?> clazz) {
        Accessor accessor = this.accessors.get(name);
        if (accessor != null) {
            return accessor;
        }
        if (clazz == null) {
            return Accessor.INVALID;
        }
        accessor = Accessor.of(clazz);
        this.accessors.put(name, accessor);
        this.names.put(clazz, name);
        return accessor;
    }

    void clear() {
        this.names.clear();
        this.accessors.clear();
    }

    void remove(Class<?> owner) {
        String name = this.names.remove(owner);
        if (name == null) {
            return;
        }
        this.accessors.remove(name);
    }
}

