/*
 * Decompiled with CFR 0.152.
 */
package me.lauriichan.laylib.json.util;

import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;

public final class PrimitiveMapper {
    private static final Object2ObjectMap<Class<?>, Class<?>> primitiveMapping;
    private static final Object2ObjectMap<Class<?>, Class<?>> complexMapping;

    public static Class<?> fromPrimitive(Class<?> type) {
        return (Class)primitiveMapping.getOrDefault(type, type);
    }

    public static Class<?> toPrimitive(Class<?> type) {
        return (Class)complexMapping.getOrDefault(type, type);
    }

    static {
        Object2ObjectArrayMap map = new Object2ObjectArrayMap(8);
        map.put(Void.TYPE, Void.class);
        map.put(Boolean.TYPE, Boolean.class);
        map.put(Byte.TYPE, Byte.class);
        map.put(Short.TYPE, Short.class);
        map.put(Integer.TYPE, Integer.class);
        map.put(Long.TYPE, Long.class);
        map.put(Float.TYPE, Float.class);
        map.put(Double.TYPE, Double.class);
        primitiveMapping = Object2ObjectMaps.unmodifiable((Object2ObjectMap)map);
        map = new Object2ObjectArrayMap(8);
        for (Object2ObjectMap.Entry entry : primitiveMapping.object2ObjectEntrySet()) {
            map.put((Object)((Class)entry.getValue()), (Object)((Class)entry.getKey()));
        }
        complexMapping = Object2ObjectMaps.unmodifiable((Object2ObjectMap)map);
    }
}

