/*
 * Decompiled with CFR 0.152.
 */
package me.lauriichan.laylib.json.io;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Map;
import me.lauriichan.laylib.json.IJson;
import me.lauriichan.laylib.json.IJsonNumber;
import me.lauriichan.laylib.json.JsonArray;
import me.lauriichan.laylib.json.JsonBoolean;
import me.lauriichan.laylib.json.JsonNull;
import me.lauriichan.laylib.json.JsonObject;
import me.lauriichan.laylib.json.JsonString;

public final class JsonWriter {
    private static final String[] ESCAPE_CHARS = new String[128];
    public static final int TAB_SPACES = 4;
    private boolean pretty = false;
    private boolean spaces = false;
    private int indent = 1;

    public boolean isPretty() {
        return this.pretty;
    }

    public JsonWriter setPretty(boolean pretty) {
        this.pretty = pretty;
        return this;
    }

    public boolean usesSpaces() {
        return this.spaces;
    }

    public JsonWriter setSpaces(boolean spaces) {
        this.spaces = spaces;
        return this;
    }

    public int getIndent() {
        return this.indent;
    }

    public JsonWriter setIndent(int indent) {
        this.indent = indent;
        return this;
    }

    public JsonWriter setTabIndent(int indent) {
        this.indent = indent * 4;
        return this;
    }

    public String toString(IJson<?> value) throws IOException {
        try (StringWriter writer = new StringWriter();){
            this.toWriter(value, writer);
            String string = writer.toString();
            return string;
        }
    }

    public byte[] toBytes(IJson<?> value) throws IOException {
        try (ByteArrayOutputStream stream = new ByteArrayOutputStream();){
            this.toStream(value, stream);
            byte[] byArray = stream.toByteArray();
            return byArray;
        }
    }

    public void toWriter(IJson<?> value, Writer writer) throws IOException {
        this.writeValue(value, writer, 0);
    }

    public void toStream(IJson<?> value, OutputStream stream) throws IOException {
        try (OutputStreamWriter writer = new OutputStreamWriter(stream, StandardCharsets.UTF_8);){
            this.toWriter(value, writer);
        }
    }

    public void toFile(IJson<?> value, File file) throws IOException {
        try (FileWriter writer = new FileWriter(file);){
            this.toWriter(value, writer);
        }
    }

    public void toPath(IJson<?> value, Path path) throws IOException {
        try (OutputStream stream = path.getFileSystem().provider().newOutputStream(path, StandardOpenOption.CREATE);){
            this.toStream(value, stream);
        }
    }

    private void writeEntry(Map.Entry<String, IJson<?>> entry, Writer writer, int depth) throws IOException {
        if (this.pretty) {
            this.indent(writer, depth);
        }
        this.writeStringObject(entry.getKey(), writer);
        writer.append(':');
        if (this.pretty) {
            writer.append(' ');
        }
        this.writeValue(entry.getValue(), writer, depth);
    }

    private void writeValue(IJson<?> value, Writer writer, int depth) throws IOException {
        switch (value.type()) {
            case NULL: {
                this.writeNull((JsonNull)value, writer);
                break;
            }
            case ARRAY: {
                this.writeArray((JsonArray)value, writer, depth);
                break;
            }
            case OBJECT: {
                this.writeObject((JsonObject)value, writer, depth);
                break;
            }
            case STRING: {
                this.writeString((JsonString)value, writer);
                break;
            }
            case BOOLEAN: {
                this.writeBoolean((JsonBoolean)value, writer);
                break;
            }
            case BYTE: 
            case SHORT: 
            case INTEGER: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case BIG_INTEGER: 
            case BIG_DECIMAL: {
                this.writeNumber((IJsonNumber)value, writer);
                break;
            }
            case NUMBER: {
                break;
            }
        }
    }

    private void writeObject(JsonObject object, Writer writer, int depth) throws IOException {
        writer.append('{');
        int size = object.size();
        if (size != 0) {
            if (this.pretty) {
                writer.append('\n');
            }
            int current = 0;
            int deep = depth + 1;
            for (Map.Entry entry : object) {
                this.writeEntry(entry, writer, deep);
                if (++current != size) {
                    writer.append(',');
                }
                if (!this.pretty) continue;
                writer.append('\n');
            }
            if (this.pretty) {
                this.indent(writer, depth);
            }
        }
        writer.append('}');
    }

    private void writeArray(JsonArray array, Writer writer, int depth) throws IOException {
        writer.append('[');
        int size = array.size();
        if (size != 0) {
            if (this.pretty) {
                writer.append('\n');
            }
            int current = 0;
            int deep = depth + 1;
            for (IJson<?> value : array) {
                if (this.pretty) {
                    this.indent(writer, deep);
                }
                this.writeValue(value, writer, deep);
                if (++current != size) {
                    writer.append(',');
                }
                if (!this.pretty) continue;
                writer.append('\n');
            }
            if (this.pretty) {
                this.indent(writer, depth);
            }
        }
        writer.append(']');
    }

    private void writeString(JsonString string, Writer writer) throws IOException {
        this.writeStringObject(string.value(), writer);
    }

    private void writeNumber(IJsonNumber<?> number, Writer writer) throws IOException {
        writer.append(((Number)number.value()).toString());
    }

    private void writeNull(JsonNull jsonNull, Writer writer) throws IOException {
        writer.append("null");
    }

    private void writeBoolean(JsonBoolean jsonBoolean, Writer writer) throws IOException {
        writer.append(jsonBoolean.value().toString());
    }

    private void indent(Writer writer, int depth) throws IOException {
        int amount = this.indent * depth;
        char append = this.spaces ? (char)' ' : '\t';
        for (int count = 0; count < amount; ++count) {
            writer.append(append);
        }
    }

    private void writeStringObject(String string, Writer writer) throws IOException {
        char[] array = string.toCharArray();
        StringBuilder builder = new StringBuilder("\"");
        for (int index = 0; index < array.length; ++index) {
            String escaped;
            char character = array[index];
            if (character < '\u0080' && (escaped = ESCAPE_CHARS[character]) != null) {
                builder.append(escaped);
                continue;
            }
            if (character == '\u2028') {
                builder.append("\\u2028");
                continue;
            }
            if (character == '\u2029') {
                builder.append("\\u2029");
                continue;
            }
            builder.append(character);
        }
        writer.append(builder.append('\"').toString());
    }

    static {
        JsonWriter.ESCAPE_CHARS[8] = "\\b";
        JsonWriter.ESCAPE_CHARS[12] = "\\f";
        JsonWriter.ESCAPE_CHARS[10] = "\\n";
        JsonWriter.ESCAPE_CHARS[13] = "\\r";
        JsonWriter.ESCAPE_CHARS[9] = "\\t";
        JsonWriter.ESCAPE_CHARS[34] = "\\\"";
        JsonWriter.ESCAPE_CHARS[92] = "\\\\";
        for (int code = 0; code < 31; ++code) {
            JsonWriter.ESCAPE_CHARS[code] = String.format("\\u%04x", code);
        }
    }
}

