/*
 * Decompiled with CFR 0.152.
 */
package me.lauriichan.laylib.json.io;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.io.IOException;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.EmptyStackException;
import me.lauriichan.laylib.json.io.EndOfFileException;
import me.lauriichan.laylib.json.io.JsonScope;
import me.lauriichan.laylib.json.io.JsonState;
import me.lauriichan.laylib.json.io.JsonSyntaxException;
import me.lauriichan.laylib.json.io.JsonToken;

final class JsonReader
implements AutoCloseable {
    public static final int INDICATOR_EOL = 0;
    public static final int INDICATOR_EOC = 1;
    public static final int LENGTH_BYTE = 3;
    public static final int LENGTH_SHORT = 5;
    public static final int LENGTH_INTEGER = 10;
    public static final int LENGTH_LONG = 19;
    public static final int LENGTH_FLOAT = 21;
    public static final int LENGTH_DOUBLE = 79;
    public static final BigInteger SIZE_BYTE = BigInteger.valueOf(127L);
    public static final BigInteger SIZE_SHORT = BigInteger.valueOf(32767L);
    public static final BigInteger SIZE_INTEGER = BigInteger.valueOf(Integer.MAX_VALUE);
    public static final BigInteger SIZE_LONG = BigInteger.valueOf(Long.MAX_VALUE);
    public static final BigDecimal SIZE_FLOAT = new BigDecimal(3.4028234663852886E38);
    public static final BigDecimal SIZE_DOUBLE = new BigDecimal(Double.MAX_VALUE);
    public static final int NUMBER_ZERO = -2;
    public static final int NUMBER_NONE = -1;
    public static final int NUMBER_DIGIT = 0;
    public static final int NUMBER_SIGN = 1;
    public static final int NUMBER_DECIMAL = 2;
    public static final int NUMBER_EXP_IND = 10;
    public static final int NUMBER_EXP_SIGN = 11;
    public static final int NUMBER_EXP_DIGIT = 12;
    public static final int NUMBER_EXP_FRAC = 13;
    public final Reader reader;
    public final char[] buffer = new char[1024];
    public final ObjectArrayList<JsonScope> stack = new ObjectArrayList();
    public JsonScope scope;
    public JsonState state;
    public int limit;
    public int cursor;
    public int lineAmount;
    public int linePosition;
    public String stringBuffer;

    public JsonReader(Reader reader) throws IOException {
        this.reader = reader;
        this.stack.push((Object)JsonScope.EMPTY_READER);
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    public JsonToken next() throws IOException, JsonSyntaxException {
        return this.currentState().asToken();
    }

    public boolean hasNext() throws IOException, JsonSyntaxException {
        JsonState state = this.currentState();
        return state != JsonState.EOF;
    }

    public String readName() throws IOException, JsonSyntaxException, IllegalStateException {
        JsonState current = this.currentState();
        switch (current) {
            case KEY_SINGLE: {
                this.resetState();
                return this.readSingleString();
            }
            case KEY_DOUBLE: {
                this.resetState();
                return this.readDoubleString();
            }
        }
        throw this.illegalState(JsonToken.KEY, current);
    }

    public String readString() throws IOException, JsonSyntaxException, IllegalStateException {
        JsonState state = this.currentState();
        switch (state.asToken().actualToken()) {
            case STRING: {
                this.resetState();
                return state == JsonState.VALUE_SINGLE ? this.readSingleString() : this.readDoubleString();
            }
            case NUMBER: {
                this.resetState();
                return this.stringBuffer;
            }
        }
        throw this.illegalState(JsonToken.STRING, state);
    }

    public boolean readBoolean() throws IOException, JsonSyntaxException, IllegalStateException {
        JsonState state = this.currentState();
        switch (state) {
            case TRUE: {
                this.resetState();
                return true;
            }
            case FALSE: {
                this.resetState();
                return false;
            }
        }
        throw this.illegalState(JsonToken.BOOLEAN, state);
    }

    public byte readByte() throws IOException, JsonSyntaxException, IllegalStateException, NumberFormatException {
        JsonState state = this.currentState();
        if (state != JsonState.BYTE) {
            throw this.illegalState(JsonToken.BYTE, state);
        }
        this.resetState();
        return Byte.parseByte(this.stringBuffer);
    }

    public short readShort() throws IOException, JsonSyntaxException, IllegalStateException, NumberFormatException {
        JsonState state = this.currentState();
        if (state != JsonState.SHORT) {
            throw this.illegalState(JsonToken.SHORT, state);
        }
        this.resetState();
        return Short.parseShort(this.stringBuffer);
    }

    public int readInteger() throws IOException, JsonSyntaxException, IllegalStateException, NumberFormatException {
        JsonState state = this.currentState();
        if (state != JsonState.INTEGER) {
            throw this.illegalState(JsonToken.INTEGER, state);
        }
        this.resetState();
        return Integer.parseInt(this.stringBuffer);
    }

    public long readLong() throws IOException, JsonSyntaxException, IllegalStateException, NumberFormatException {
        JsonState state = this.currentState();
        if (state != JsonState.LONG) {
            throw this.illegalState(JsonToken.LONG, state);
        }
        this.resetState();
        return Long.parseLong(this.stringBuffer);
    }

    public BigInteger readBigInteger() throws IOException, JsonSyntaxException, IllegalStateException, NumberFormatException {
        JsonState state = this.currentState();
        if (state != JsonState.BIG_INTEGER) {
            throw this.illegalState(JsonToken.BIG_INTEGER, state);
        }
        this.resetState();
        return new BigInteger(this.stringBuffer);
    }

    public float readFloat() throws IOException, JsonSyntaxException, IllegalStateException, NumberFormatException {
        JsonState state = this.currentState();
        if (state != JsonState.FLOAT) {
            throw this.illegalState(JsonToken.FLOAT, state);
        }
        this.resetState();
        return Float.parseFloat(this.stringBuffer);
    }

    public double readDouble() throws IOException, JsonSyntaxException, IllegalStateException, NumberFormatException {
        JsonState state = this.currentState();
        if (state != JsonState.DOUBLE) {
            throw this.illegalState(JsonToken.DOUBLE, state);
        }
        this.resetState();
        return Double.parseDouble(this.stringBuffer);
    }

    public BigDecimal readBigDecimal() throws IOException, JsonSyntaxException, IllegalStateException, NumberFormatException {
        JsonState state = this.currentState();
        if (state != JsonState.BIG_DECIMAL) {
            throw this.illegalState(JsonToken.BIG_DECIMAL, state);
        }
        this.resetState();
        return new BigDecimal(this.stringBuffer);
    }

    public Number readNumber() throws IOException, JsonSyntaxException, IllegalStateException, NumberFormatException {
        JsonState state = this.currentState();
        switch (state) {
            case BYTE: {
                return this.readByte();
            }
            case SHORT: {
                return this.readShort();
            }
            case INTEGER: {
                return this.readInteger();
            }
            case LONG: {
                return this.readLong();
            }
            case BIG_INTEGER: {
                return this.readBigInteger();
            }
            case FLOAT: {
                return Float.valueOf(this.readFloat());
            }
            case DOUBLE: {
                return this.readDouble();
            }
            case BIG_DECIMAL: {
                return this.readBigDecimal();
            }
        }
        throw this.illegalState(JsonToken.NUMBER, state, true);
    }

    public void readNull() throws IOException, JsonSyntaxException, IllegalStateException {
        JsonState state = this.currentState();
        if (state != JsonState.NULL) {
            throw this.illegalState(JsonToken.NULL, state);
        }
        this.resetState();
    }

    public void beginArray() throws IOException, JsonSyntaxException, IllegalStateException {
        JsonState current = this.currentState();
        if (current != JsonState.START_ARRAY) {
            throw this.illegalState(JsonToken.START_ARRAY, current);
        }
        this.stack.push((Object)JsonScope.EMPTY_ARRAY);
        this.resetState();
    }

    public void endArray() throws IOException, JsonSyntaxException, IllegalStateException {
        JsonState current = this.currentState();
        if (current != JsonState.END_ARRAY) {
            throw this.illegalState(JsonToken.END_ARRAY, current);
        }
        this.resetState();
    }

    public void beginObject() throws IOException, JsonSyntaxException, IllegalStateException {
        JsonState current = this.currentState();
        if (current != JsonState.START_OBJECT) {
            throw this.illegalState(JsonToken.START_OBJECT, current);
        }
        this.stack.push((Object)JsonScope.EMPTY_OBJECT);
        this.resetState();
    }

    public void endObject() throws IOException, JsonSyntaxException, IllegalStateException {
        JsonState current = this.currentState();
        if (current != JsonState.END_OBJECT) {
            throw this.illegalState(JsonToken.END_OBJECT, current);
        }
        this.resetState();
    }

    private String readSingleString() throws IOException, JsonSyntaxException {
        char[] buffer = this.buffer;
        StringBuilder builder = null;
        do {
            int position = this.cursor;
            int limit = this.limit;
            int start = position;
            block6: while (position < limit) {
                char current = buffer[position++];
                switch (current) {
                    case '\'': {
                        this.cursor = position;
                        int length0 = position - start - 1;
                        if (builder == null) {
                            return new String(buffer, start, length0);
                        }
                        return builder.append(buffer, start, length0).toString();
                    }
                    case '\\': {
                        this.cursor = position;
                        int length1 = position - start - 1;
                        if (builder == null) {
                            builder = new StringBuilder(Math.max((length1 + 1) * 2, 16));
                        }
                        builder.append(buffer, start, length1);
                        builder.append(this.readEscapeCharacter());
                        position = this.cursor;
                        limit = this.limit;
                        start = position;
                        continue block6;
                    }
                    case '\n': {
                        ++this.lineAmount;
                        this.linePosition = position;
                        continue block6;
                    }
                }
            }
            if (builder == null) {
                builder = new StringBuilder(Math.max((position - start) * 2, 16));
            }
            builder.append(buffer, start, position - start);
            this.cursor = position;
        } while (this.readToBuffer(1));
        throw this.wrongSyntax("Never ending string");
    }

    private String readDoubleString() throws IOException, JsonSyntaxException {
        char[] buffer = this.buffer;
        StringBuilder builder = null;
        do {
            int position = this.cursor;
            int limit = this.limit;
            int start = position;
            block6: while (position < limit) {
                char current = buffer[position++];
                switch (current) {
                    case '\"': {
                        this.cursor = position;
                        int length0 = position - start - 1;
                        if (builder == null) {
                            return new String(buffer, start, length0);
                        }
                        return builder.append(buffer, start, length0).toString();
                    }
                    case '\\': {
                        this.cursor = position;
                        int length1 = position - start - 1;
                        if (builder == null) {
                            builder = new StringBuilder(Math.max((length1 + 1) * 2, 16));
                        }
                        builder.append(buffer, start, length1);
                        builder.append(this.readEscapeCharacter());
                        position = this.cursor;
                        limit = this.limit;
                        start = position;
                        continue block6;
                    }
                    case '\n': {
                        ++this.lineAmount;
                        this.linePosition = position;
                        continue block6;
                    }
                }
            }
            if (builder == null) {
                builder = new StringBuilder(Math.max((position - start) * 2, 16));
            }
            builder.append(buffer, start, position - start);
            this.cursor = position;
        } while (this.readToBuffer(1));
        throw this.wrongSyntax("Never ending string");
    }

    private char readEscapeCharacter() throws IOException, JsonSyntaxException, NumberFormatException {
        if (this.cursor == this.limit && !this.readToBuffer(1)) {
            throw this.wrongSyntax("Never ending escape sequence");
        }
        char current = this.buffer[this.cursor++];
        switch (current) {
            case 'u': {
                int index;
                if (this.cursor + 4 > this.limit && !this.readToBuffer(4)) {
                    throw this.wrongSyntax("Never ending escape sequence");
                }
                char output = '\u0000';
                int max = index + 4;
                for (index = this.cursor; index < max; ++index) {
                    char check = this.buffer[index];
                    output = (char)(output << 4);
                    if (check >= '0' && check <= '9') {
                        output = (char)(output + (check - 48));
                        continue;
                    }
                    if (check >= 'a' && check <= 'f') {
                        output = (char)(output + (check - 97 + 10));
                        continue;
                    }
                    if (check >= 'A' && check <= 'F') {
                        output = (char)(output + (check - 65 + 10));
                        continue;
                    }
                    throw new NumberFormatException("\\u" + new String(this.buffer, this.cursor, 4));
                }
                this.cursor += 4;
                return output;
            }
            case 't': {
                return '\t';
            }
            case 'b': {
                return '\b';
            }
            case 'n': {
                return '\n';
            }
            case 'r': {
                return '\r';
            }
            case 'f': {
                return '\f';
            }
            case '\n': {
                ++this.lineAmount;
                this.linePosition = this.cursor;
            }
            case '\"': 
            case '\'': 
            case '/': 
            case '\\': {
                return current;
            }
        }
        throw this.wrongSyntax("Invalid exscaped sequence");
    }

    private void resetState() {
        this.state = null;
        this.scope = null;
    }

    private JsonState currentState() throws IOException, JsonSyntaxException {
        JsonState current = this.state;
        if (current == null) {
            current = this.nextState();
        }
        return current;
    }

    public String stackAsString() {
        StringBuilder builder = new StringBuilder("[");
        ObjectListIterator iterator = this.stack.iterator();
        while (iterator.hasNext()) {
            builder.append(((JsonScope)((Object)iterator.next())).name());
            if (!iterator.hasNext()) continue;
            builder.append(", ");
        }
        return builder.append("]").toString();
    }

    private JsonState nextState() throws IOException, JsonSyntaxException {
        JsonScope current = this.scope;
        if (this.scope == null) {
            current = this.scope = this.peek();
        }
        try {
            block1 : switch (current) {
                case EMPTY_ARRAY: {
                    this.pop();
                    this.stack.push((Object)JsonScope.FILLED_ARRAY);
                    break;
                }
                case FILLED_ARRAY: {
                    char character3 = this.nextCharacter();
                    switch (character3) {
                        case ']': {
                            this.pop();
                            this.state = JsonState.END_ARRAY;
                            return this.state;
                        }
                        case ',': {
                            break block1;
                        }
                    }
                    throw this.wrongSyntax("Never ending array");
                }
                case EMPTY_OBJECT: 
                case FILLED_OBJECT: {
                    this.pop();
                    this.stack.push((Object)JsonScope.PENDING_NAME);
                    if (current == JsonScope.FILLED_OBJECT) {
                        char character1 = this.nextCharacter();
                        switch (character1) {
                            case '}': {
                                this.pop();
                                this.state = JsonState.END_OBJECT;
                                return this.state;
                            }
                            case ',': {
                                break;
                            }
                            default: {
                                throw this.wrongSyntax("Never ending object");
                            }
                        }
                    }
                    char character2 = this.nextCharacter();
                    switch (character2) {
                        case '\'': {
                            this.state = JsonState.KEY_SINGLE;
                            return this.state;
                        }
                        case '\"': {
                            this.state = JsonState.KEY_DOUBLE;
                            return this.state;
                        }
                        case '}': {
                            if (current == JsonScope.FILLED_OBJECT) {
                                this.wrongSyntax("Unnamed element");
                            }
                            this.pop();
                            this.state = JsonState.END_OBJECT;
                            return this.state;
                        }
                    }
                    throw this.wrongSyntax("Unnamed element");
                }
                case EMPTY_READER: {
                    this.stack.push((Object)JsonScope.FILLED_READER);
                    break;
                }
                case FILLED_READER: {
                    this.pop();
                    this.nextCharacter();
                    --this.cursor;
                    break;
                }
                case PENDING_NAME: {
                    this.pop();
                    this.stack.push((Object)JsonScope.FILLED_OBJECT);
                    char character0 = this.nextCharacter();
                    if (character0 == ':') break;
                    throw this.wrongSyntax("Expected ':'");
                }
                case CLOSED: {
                    this.state = JsonState.EOF;
                    return this.state;
                }
            }
            char character = this.nextCharacter();
            switch (character) {
                case ']': {
                    if (current != JsonScope.EMPTY_ARRAY) break;
                    this.pop();
                    this.state = JsonState.END_ARRAY;
                    return this.state;
                }
                case ',': {
                    throw this.wrongSyntax("Unexpected value");
                }
                case '\'': {
                    this.state = JsonState.VALUE_SINGLE;
                    return this.state;
                }
                case '\"': {
                    this.state = JsonState.VALUE_DOUBLE;
                    return this.state;
                }
                case '[': {
                    this.state = JsonState.START_ARRAY;
                    return this.state;
                }
                case '{': {
                    this.state = JsonState.START_OBJECT;
                    return this.state;
                }
                default: {
                    --this.cursor;
                }
            }
            if (this.isKeyword() || this.isNumber()) {
                return this.state;
            }
            throw this.wrongSyntax("No value present");
        }
        catch (EndOfFileException eof) {
            this.state = JsonState.EOF;
            return this.state;
        }
    }

    private boolean isKeyword() throws IOException, JsonSyntaxException {
        JsonState expect;
        String wordUpped;
        String word;
        char current = this.buffer[this.cursor];
        switch (current) {
            case 'T': 
            case 't': {
                word = "true";
                wordUpped = "TRUE";
                expect = JsonState.TRUE;
                break;
            }
            case 'F': 
            case 'f': {
                word = "false";
                wordUpped = "FALSE";
                expect = JsonState.FALSE;
                break;
            }
            case 'N': 
            case 'n': {
                word = "null";
                wordUpped = "NULL";
                expect = JsonState.NULL;
                break;
            }
            default: {
                return false;
            }
        }
        int length = word.length();
        for (int index = 1; index < length; ++index) {
            if (this.cursor + index >= this.limit && !this.readToBuffer(index + 1)) {
                return false;
            }
            char character = this.buffer[this.cursor + index];
            if (character == word.charAt(index) || character == wordUpped.charAt(index)) continue;
            return false;
        }
        if ((this.cursor + length < this.limit || this.readToBuffer(length + 1)) && this.isLiteral(this.buffer[this.cursor + length])) {
            return false;
        }
        this.cursor += length;
        this.state = expect;
        return true;
    }

    private boolean isNumber() throws IOException, JsonSyntaxException {
        char[] buffer = this.buffer;
        int position = this.cursor;
        int limit = this.limit;
        boolean first = true;
        boolean decimal = false;
        boolean negative = false;
        boolean exponential = false;
        boolean exponentialNegative = false;
        StringBuilder value = new StringBuilder();
        StringBuilder exponentialValue = new StringBuilder();
        int parser = -1;
        int index = 0;
        int read = 0;
        block36: while (true) {
            if (position + index == limit) {
                if (!this.readToBuffer(1)) break;
                if (this.cursor == 0) {
                    read = index;
                }
                position = this.cursor;
                limit = this.limit;
            }
            char current = buffer[position + index];
            block1 : switch (current) {
                case '-': {
                    switch (parser) {
                        case -1: {
                            negative = true;
                            parser = 1;
                            value.append(current);
                            break block1;
                        }
                        case 10: {
                            parser = 11;
                            exponentialNegative = true;
                            value.append(current);
                            break block1;
                        }
                        case -2: {
                            break block1;
                        }
                    }
                    return false;
                }
                case '+': {
                    switch (parser) {
                        case -1: {
                            parser = 1;
                            value.append(current);
                            break block1;
                        }
                        case 10: {
                            parser = 11;
                            value.append(current);
                            break block1;
                        }
                        case -2: {
                            break block1;
                        }
                    }
                    return false;
                }
                case 'E': 
                case 'e': {
                    if (parser != 0 && parser != -1 || exponential) {
                        return false;
                    }
                    if (first) {
                        first = false;
                        parser = -2;
                        value.append('0');
                        break;
                    }
                    exponential = true;
                    parser = 10;
                    value.append(current);
                    break;
                }
                case '.': {
                    if (!first && (parser != 0 || decimal)) {
                        return false;
                    }
                    if (first) {
                        value.append('0');
                    }
                    decimal = true;
                    parser = 2;
                    value.append(current);
                    break;
                }
                default: {
                    if (!this.isDigit(current)) {
                        if (!this.isLiteral(current)) break block36;
                        return false;
                    }
                    switch (parser) {
                        case -1: {
                            if (first && current == '0') break block1;
                            first = false;
                            parser = 0;
                            value.append(current);
                            break block1;
                        }
                        case 1: {
                            if (first && current == '0') break block1;
                            first = false;
                            parser = 0;
                            value.append(current);
                            break block1;
                        }
                        case 0: {
                            value.append(current);
                            break block1;
                        }
                        case 2: {
                            value.append(current);
                            parser = 0;
                            break block1;
                        }
                        case 10: 
                        case 11: 
                        case 12: {
                            value.append(current);
                            exponentialValue.append(current);
                            parser = 12;
                            break block1;
                        }
                        case -2: {
                            break block1;
                        }
                        default: {
                            return false;
                        }
                    }
                }
            }
            ++index;
            ++read;
        }
        try {
            this.stringBuffer = value.toString();
            if (this.stringBuffer.length() == 0) {
                this.stringBuffer = "0";
                this.state = JsonState.BYTE;
                ++this.cursor;
                return true;
            }
            int length = (decimal ? this.stringBuffer.split("\\.", 2)[0].length() : this.stringBuffer.length()) - (negative ? 1 : 0);
            if (decimal) {
                if (exponential && exponentialValue.length() > 0) {
                    BigDecimal number = new BigDecimal(this.stringBuffer.split("E", 2)[0]);
                    int amount = Integer.parseInt(exponentialValue.toString());
                    BigDecimal bigDecimal = number = exponentialNegative ? number.movePointLeft(amount) : number.movePointRight(amount);
                    this.state = this.hasSize(number, SIZE_FLOAT, negative) ? JsonState.FLOAT : (this.hasSize(number, SIZE_DOUBLE, negative) ? JsonState.DOUBLE : JsonState.BIG_DECIMAL);
                } else {
                    switch (length) {
                        case 21: {
                            this.state = this.isLower(this.stringBuffer, SIZE_FLOAT, negative) ? JsonState.FLOAT : JsonState.DOUBLE;
                            break;
                        }
                        case 79: {
                            this.state = this.isLower(this.stringBuffer, SIZE_DOUBLE, negative) ? JsonState.DOUBLE : JsonState.BIG_DECIMAL;
                            break;
                        }
                        default: {
                            if (length < 21) {
                                this.state = JsonState.FLOAT;
                                break;
                            }
                            if (length < 79) {
                                this.state = JsonState.DOUBLE;
                                break;
                            }
                            this.state = JsonState.BIG_DECIMAL;
                            break;
                        }
                    }
                }
            } else {
                switch (length) {
                    case 3: {
                        this.state = this.isLower(this.stringBuffer, SIZE_BYTE, negative) ? JsonState.BYTE : JsonState.SHORT;
                        break;
                    }
                    case 5: {
                        this.state = this.isLower(this.stringBuffer, SIZE_SHORT, negative) ? JsonState.SHORT : JsonState.INTEGER;
                        break;
                    }
                    case 10: {
                        this.state = this.isLower(this.stringBuffer, SIZE_INTEGER, negative) ? JsonState.INTEGER : JsonState.LONG;
                        break;
                    }
                    case 19: {
                        this.state = this.isLower(this.stringBuffer, SIZE_LONG, negative) ? JsonState.LONG : JsonState.BIG_INTEGER;
                        break;
                    }
                    default: {
                        this.state = length < 3 ? JsonState.BYTE : (length < 5 ? JsonState.SHORT : (length < 10 ? JsonState.INTEGER : (length < 19 ? JsonState.LONG : JsonState.BIG_INTEGER)));
                    }
                }
            }
            this.cursor += read;
            return true;
        }
        catch (NumberFormatException exception) {
            exception.printStackTrace();
            throw new IllegalStateException("fail", exception);
        }
    }

    private boolean hasSize(BigDecimal compare, BigDecimal comparision, boolean negative) {
        if (negative) {
            return compare.compareTo(comparision.multiply(BigDecimal.ONE.negate())) >= 1;
        }
        return compare.compareTo(comparision) <= -1;
    }

    private boolean isLower(String value, BigDecimal comparision, boolean negative) {
        if (negative) {
            return new BigDecimal(value).compareTo(comparision.multiply(BigDecimal.ONE.negate())) == 1;
        }
        return new BigDecimal(value).compareTo(comparision) == -1;
    }

    private boolean isLower(String value, BigInteger comparision, boolean negative) {
        if (negative) {
            return new BigInteger(value).compareTo(comparision.multiply(BigInteger.ONE.negate())) == 1;
        }
        return new BigInteger(value).compareTo(comparision) == -1;
    }

    private char nextCharacter() throws IOException, EndOfFileException, JsonSyntaxException {
        block15: {
            char current;
            char[] buffer = this.buffer;
            int position = this.cursor;
            int limit = this.limit;
            block10: while (true) {
                if (position == limit) {
                    this.cursor = position;
                    if (!this.readToBuffer(1)) break block15;
                    position = this.cursor;
                    limit = this.limit;
                }
                current = buffer[position++];
                switch (current) {
                    case '\n': {
                        ++this.lineAmount;
                        this.linePosition = position;
                        continue block10;
                    }
                    case '\t': 
                    case '\r': 
                    case ' ': {
                        continue block10;
                    }
                    case '/': {
                        this.cursor = position;
                        if (position == limit) {
                            --this.cursor;
                            boolean loaded = this.readToBuffer(2);
                            ++this.cursor;
                            if (!loaded) {
                                return current;
                            }
                        }
                        char test = buffer[this.cursor];
                        switch (test) {
                            case '*': {
                                ++this.cursor;
                                if (!this.skipTo(1)) {
                                    throw this.wrongSyntax("Never ending comment");
                                }
                                position = this.cursor + 2;
                                limit = this.limit;
                                continue block10;
                            }
                            case '/': {
                                ++this.cursor;
                                this.skipTo(0);
                                position = this.cursor;
                                limit = this.limit;
                                continue block10;
                            }
                        }
                        return current;
                    }
                    case '#': {
                        this.cursor = position;
                        this.skipTo(0);
                        position = this.cursor;
                        limit = this.limit;
                        continue block10;
                    }
                }
                break;
            }
            this.cursor = position;
            return current;
        }
        throw new EndOfFileException();
    }

    private boolean skipTo(int indicator) throws IOException {
        switch (indicator) {
            case 0: {
                block8: while (this.cursor < this.limit || this.readToBuffer(1)) {
                    char current = this.buffer[this.cursor++];
                    switch (current) {
                        case '\n': {
                            ++this.lineAmount;
                            this.linePosition = this.cursor;
                        }
                        case '\r': {
                            break block8;
                        }
                        default: {
                            continue block8;
                        }
                    }
                }
                return true;
            }
            case 1: {
                while (this.cursor + 2 <= this.limit || this.readToBuffer(2)) {
                    if (this.buffer[this.cursor] == '\n') {
                        ++this.lineAmount;
                        this.linePosition = this.cursor + 1;
                    } else if (this.buffer[this.cursor] == '*' && this.buffer[this.cursor + 1] == '/') {
                        return true;
                    }
                    ++this.cursor;
                }
                return false;
            }
        }
        return true;
    }

    private boolean readToBuffer(int minimum) throws IOException {
        int total;
        char[] buffer = this.buffer;
        this.linePosition -= this.cursor;
        if (this.limit != this.cursor) {
            this.limit -= this.cursor;
            System.arraycopy(buffer, this.cursor, buffer, 0, this.limit);
        } else {
            this.limit = 0;
        }
        this.cursor = 0;
        while ((total = this.reader.read(buffer, this.limit, buffer.length - this.limit)) != -1) {
            this.limit += total;
            if (this.lineAmount == 0 && this.linePosition == 0 && this.limit > 0 && buffer[0] == '\ufeff') {
                ++this.cursor;
                ++this.linePosition;
                ++minimum;
            }
            if (this.limit < minimum) continue;
            return true;
        }
        return false;
    }

    private boolean isDigit(char character) {
        return character >= '0' && character <= '9';
    }

    private boolean isLiteral(char character) throws JsonSyntaxException {
        switch (character) {
            case '\t': 
            case '\n': 
            case '\f': 
            case '\r': 
            case ' ': 
            case '#': 
            case ',': 
            case '/': 
            case ':': 
            case '[': 
            case ']': 
            case '{': 
            case '}': {
                return false;
            }
            case ';': 
            case '=': 
            case '\\': {
                throw this.wrongSyntax("Unexpected character");
            }
        }
        return true;
    }

    private JsonScope pop() {
        try {
            return (JsonScope)((Object)this.stack.pop());
        }
        catch (EmptyStackException exception) {
            return JsonScope.CLOSED;
        }
    }

    private JsonScope peek() {
        try {
            return (JsonScope)((Object)this.stack.top());
        }
        catch (EmptyStackException exception) {
            return JsonScope.CLOSED;
        }
    }

    private JsonSyntaxException wrongSyntax(String message) {
        return new JsonSyntaxException(this.applyLocation(message));
    }

    private IllegalStateException illegalState(JsonToken expected, JsonState state) {
        return this.illegalState(expected, state, false);
    }

    private IllegalStateException illegalState(JsonToken expected, JsonState state, boolean actual) {
        return new IllegalStateException(this.applyLocation("Expected " + expected.name() + " but was " + (actual ? state.asToken() : state.asToken()).name()));
    }

    private String applyLocation(String message) {
        return message + this.getLocation();
    }

    private String getLocation() {
        return " at line " + (this.lineAmount + 1) + " position " + (this.cursor - this.linePosition + 1);
    }
}

