/*
 * Decompiled with CFR 0.152.
 */
package me.lauriichan.laylib.json.io;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import me.lauriichan.laylib.json.IJson;
import me.lauriichan.laylib.json.JsonArray;
import me.lauriichan.laylib.json.JsonBigDecimal;
import me.lauriichan.laylib.json.JsonBigInteger;
import me.lauriichan.laylib.json.JsonBoolean;
import me.lauriichan.laylib.json.JsonByte;
import me.lauriichan.laylib.json.JsonDouble;
import me.lauriichan.laylib.json.JsonFloat;
import me.lauriichan.laylib.json.JsonInteger;
import me.lauriichan.laylib.json.JsonLong;
import me.lauriichan.laylib.json.JsonObject;
import me.lauriichan.laylib.json.JsonShort;
import me.lauriichan.laylib.json.JsonString;
import me.lauriichan.laylib.json.io.JsonReader;
import me.lauriichan.laylib.json.io.JsonSyntaxException;
import me.lauriichan.laylib.json.io.JsonToken;

public final class JsonParser {
    private JsonParser() {
        throw new UnsupportedOperationException("Parser class doesn't need to be initialized");
    }

    public static IJson<?> fromString(String string) throws IOException, JsonSyntaxException, IllegalStateException {
        try (StringReader reader = new StringReader(string);){
            IJson<?> iJson = JsonParser.fromReader(reader);
            return iJson;
        }
    }

    public static IJson<?> fromBytes(byte[] bytes) throws IOException, JsonSyntaxException, IllegalStateException {
        try (ByteArrayInputStream stream = new ByteArrayInputStream(bytes);){
            IJson<?> iJson = JsonParser.fromStream(stream);
            return iJson;
        }
    }

    public static IJson<?> fromStream(InputStream stream) throws IOException, JsonSyntaxException, IllegalStateException {
        try (InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);){
            IJson<?> iJson = JsonParser.fromReader(reader);
            return iJson;
        }
    }

    public static IJson<?> fromReader(Reader reader) throws IOException, JsonSyntaxException, IllegalStateException {
        try (JsonReader jsonReader = new JsonReader(reader);){
            IJson<?> iJson = JsonParser.read(jsonReader);
            return iJson;
        }
    }

    public static IJson<?> fromFile(File file) throws IOException, JsonSyntaxException, IllegalStateException {
        try (FileReader reader = new FileReader(file);){
            IJson<?> iJson = JsonParser.fromReader(reader);
            return iJson;
        }
    }

    public static IJson<?> fromPath(Path path) throws IOException, JsonSyntaxException, IllegalStateException {
        try (InputStream stream = path.getFileSystem().provider().newInputStream(path, StandardOpenOption.READ);){
            IJson<?> iJson = JsonParser.fromStream(stream);
            return iJson;
        }
    }

    public static IJson<?> read(JsonReader reader) throws IOException, JsonSyntaxException, IllegalStateException {
        ObjectArrayList stack = new ObjectArrayList();
        ObjectArrayList keyStack = new ObjectArrayList();
        String key = null;
        IJson<Void> json = IJson.NULL;
        int state = 0;
        block18: while (true) {
            if (!reader.hasNext()) {
                if (stack.isEmpty()) {
                    return json;
                }
                return (IJson)stack.pop();
            }
            JsonToken token = reader.next();
            switch (token) {
                case START_OBJECT: {
                    if (state != 0) {
                        keyStack.push(key);
                        key = null;
                    }
                    reader.beginObject();
                    stack.push((Object)new JsonObject());
                    state = 2;
                    continue block18;
                }
                case KEY: {
                    if (key != null) {
                        throw new IllegalStateException();
                    }
                    key = reader.readName();
                    continue block18;
                }
                case END_OBJECT: {
                    reader.endObject();
                    json = (IJson)stack.pop();
                    if (!keyStack.isEmpty()) {
                        key = (String)keyStack.pop();
                        state = key == null ? 1 : 2;
                        break;
                    }
                    state = 0;
                    break;
                }
                case START_ARRAY: {
                    if (state != 0) {
                        keyStack.push((Object)key);
                        key = null;
                    }
                    reader.beginArray();
                    stack.push((Object)new JsonArray());
                    state = 1;
                    continue block18;
                }
                case END_ARRAY: {
                    reader.endArray();
                    json = (IJson)stack.pop();
                    if (!keyStack.isEmpty()) {
                        key = (String)keyStack.pop();
                        state = key == null ? 1 : 2;
                        break;
                    }
                    state = 0;
                    break;
                }
                case NULL: {
                    reader.readNull();
                    json = IJson.NULL;
                    break;
                }
                case STRING: {
                    json = new JsonString(reader.readString());
                    break;
                }
                case BOOLEAN: {
                    json = reader.readBoolean() ? JsonBoolean.TRUE : JsonBoolean.FALSE;
                    break;
                }
                case BYTE: {
                    json = JsonByte.of(reader.readByte());
                    break;
                }
                case SHORT: {
                    json = new JsonShort(reader.readShort());
                    break;
                }
                case INTEGER: {
                    json = new JsonInteger(reader.readInteger());
                    break;
                }
                case LONG: {
                    json = new JsonLong(reader.readLong());
                    break;
                }
                case BIG_INTEGER: {
                    json = new JsonBigInteger(reader.readBigInteger());
                    break;
                }
                case FLOAT: {
                    json = new JsonFloat(reader.readFloat());
                    break;
                }
                case DOUBLE: {
                    json = new JsonDouble(reader.readDouble());
                    break;
                }
                case BIG_DECIMAL: {
                    json = new JsonBigDecimal(reader.readBigDecimal());
                    break;
                }
                default: {
                    throw new IllegalStateException(String.format("Unexpected token: %s", new Object[]{token}));
                }
            }
            if (state != 2 && key != null) {
                throw new IllegalStateException(String.format("Unexpected key: %s", key));
            }
            if (state == 0 && !stack.isEmpty()) {
                IJson next = (IJson)stack.top();
                if (next instanceof JsonArray) {
                    state = 1;
                } else if (next instanceof JsonObject) {
                    state = 2;
                }
            }
            if (key != null) {
                ((JsonObject)stack.top()).put(key, json);
                key = null;
                continue;
            }
            if (state != 1) break;
            ((JsonArray)stack.top()).add(json);
        }
        return json;
    }
}

