/*
 * Decompiled with CFR 0.152.
 */
package me.lauriichan.laylib.json;

import me.lauriichan.laylib.json.IJson;

public enum JsonType {
    JSON,
    ARRAY(JSON),
    OBJECT(JSON),
    PRIMITIVE,
    NULL(PRIMITIVE),
    STRING(PRIMITIVE),
    NUMBER(PRIMITIVE),
    BOOLEAN(PRIMITIVE),
    BYTE(NUMBER),
    SHORT(NUMBER),
    INTEGER(NUMBER),
    LONG(NUMBER),
    BIG_INTEGER(NUMBER),
    FLOAT(NUMBER),
    DOUBLE(NUMBER),
    BIG_DECIMAL(NUMBER);

    private final JsonType parent;

    private JsonType() {
        this(null);
    }

    private JsonType(JsonType parent) {
        this.parent = parent;
    }

    public JsonType parent() {
        return this.parent;
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    public boolean isType(JsonType type) {
        return this == type || this.parent != null && this.parent.isType(type);
    }

    public boolean isPrimitive() {
        return this.isType(PRIMITIVE);
    }

    public boolean hasType(IJson<?> json) {
        return json != null && json.type().isType(this);
    }
}

