/*
 * Decompiled with CFR 0.152.
 */
package me.lauriichan.laylib.json;

import java.math.BigDecimal;
import java.math.BigInteger;
import me.lauriichan.laylib.json.IJsonNumber;
import me.lauriichan.laylib.json.JsonType;

public final class JsonShort
implements IJsonNumber<Short> {
    private final short value;

    public JsonShort(short value) {
        this.value = value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Number) {
            return this.value == ((Number)obj).shortValue();
        }
        if (obj instanceof IJsonNumber) {
            return this.value == ((IJsonNumber)obj).asShort();
        }
        return false;
    }

    public int hashCode() {
        return this.value;
    }

    @Override
    public JsonType type() {
        return JsonType.SHORT;
    }

    @Override
    public Short value() {
        return this.value;
    }

    @Override
    public byte asByte() {
        return (byte)this.value;
    }

    @Override
    public short asShort() {
        return this.value;
    }

    @Override
    public int asInt() {
        return this.value;
    }

    @Override
    public long asLong() {
        return this.value;
    }

    @Override
    public BigInteger asBigInteger() {
        return BigInteger.valueOf(this.value);
    }

    @Override
    public float asFloat() {
        return this.value;
    }

    @Override
    public double asDouble() {
        return this.value;
    }

    @Override
    public BigDecimal asBigDecimal() {
        return BigDecimal.valueOf(this.value);
    }
}

