/*
 * Decompiled with CFR 0.152.
 */
package me.lauriichan.laylib.json;

import java.math.BigDecimal;
import java.math.BigInteger;
import me.lauriichan.laylib.json.IJsonNumber;
import me.lauriichan.laylib.json.JsonType;

public final class JsonDouble
implements IJsonNumber<Double> {
    private final double value;

    public JsonDouble(double value) {
        this.value = value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Number) {
            return this.value == ((Number)obj).doubleValue();
        }
        if (obj instanceof IJsonNumber) {
            return this.value == ((IJsonNumber)obj).asDouble();
        }
        return false;
    }

    public int hashCode() {
        return Double.hashCode(this.value);
    }

    @Override
    public JsonType type() {
        return JsonType.DOUBLE;
    }

    @Override
    public Double value() {
        return this.value;
    }

    @Override
    public byte asByte() {
        return (byte)this.value;
    }

    @Override
    public short asShort() {
        return (short)this.value;
    }

    @Override
    public int asInt() {
        return (int)this.value;
    }

    @Override
    public long asLong() {
        return (long)this.value;
    }

    @Override
    public BigInteger asBigInteger() {
        return BigInteger.valueOf(this.asLong());
    }

    @Override
    public float asFloat() {
        return (float)this.value;
    }

    @Override
    public double asDouble() {
        return this.value;
    }

    @Override
    public BigDecimal asBigDecimal() {
        return BigDecimal.valueOf(this.value);
    }
}

