/*
 * Decompiled with CFR 0.152.
 */
package me.lauriichan.laylib.json;

import java.math.BigDecimal;
import java.math.BigInteger;
import me.lauriichan.laylib.json.IJsonNumber;
import me.lauriichan.laylib.json.JsonType;

public final class JsonByte
implements IJsonNumber<Byte> {
    private static final JsonByte[] BYTES = new JsonByte[256];
    private final byte value;

    public static JsonByte of(byte value) {
        return BYTES[value + 128];
    }

    private JsonByte(byte value) {
        this.value = value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Number) {
            return this.value == ((Number)obj).byteValue();
        }
        if (obj instanceof IJsonNumber) {
            return this.value == ((IJsonNumber)obj).asByte();
        }
        return false;
    }

    public int hashCode() {
        return this.value;
    }

    @Override
    public JsonType type() {
        return JsonType.BYTE;
    }

    @Override
    public Byte value() {
        return this.value;
    }

    @Override
    public byte asByte() {
        return this.value;
    }

    @Override
    public short asShort() {
        return this.value;
    }

    @Override
    public int asInt() {
        return this.value;
    }

    @Override
    public long asLong() {
        return this.value;
    }

    @Override
    public BigInteger asBigInteger() {
        return BigInteger.valueOf(this.value);
    }

    @Override
    public float asFloat() {
        return this.value;
    }

    @Override
    public double asDouble() {
        return this.value;
    }

    @Override
    public BigDecimal asBigDecimal() {
        return BigDecimal.valueOf(this.value);
    }

    static {
        byte value = -128;
        for (int index = 0; index < BYTES.length; ++index) {
            JsonByte.BYTES[index] = new JsonByte(value);
            value = (byte)(value + 1);
        }
    }
}

