/*
 * Decompiled with CFR 0.152.
 */
package me.lauriichan.laylib.json;

import java.math.BigDecimal;
import java.math.BigInteger;
import me.lauriichan.laylib.json.IJsonNumber;
import me.lauriichan.laylib.json.JsonType;

public final class JsonBigInteger
implements IJsonNumber<BigInteger> {
    private final BigInteger value;

    public JsonBigInteger(long value) {
        this.value = BigInteger.valueOf(value);
    }

    public JsonBigInteger(BigInteger value) {
        this.value = value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Number) {
            if (obj instanceof BigInteger) {
                return this.value.equals(obj);
            }
            if (obj instanceof BigDecimal) {
                try {
                    return this.value.equals(((BigDecimal)obj).toBigIntegerExact());
                }
                catch (ArithmeticException ignore) {
                    return false;
                }
            }
            return this.value.equals(BigInteger.valueOf(((Number)obj).longValue()));
        }
        if (obj instanceof IJsonNumber) {
            return this.value.equals(((IJsonNumber)obj).asBigInteger());
        }
        return false;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public JsonType type() {
        return JsonType.BIG_INTEGER;
    }

    @Override
    public BigInteger value() {
        return this.value;
    }

    @Override
    public byte asByte() {
        return this.value.byteValue();
    }

    @Override
    public short asShort() {
        return this.value.shortValue();
    }

    @Override
    public int asInt() {
        return this.value.intValue();
    }

    @Override
    public long asLong() {
        return this.value.longValue();
    }

    @Override
    public BigInteger asBigInteger() {
        return this.value;
    }

    @Override
    public float asFloat() {
        return this.value.floatValue();
    }

    @Override
    public double asDouble() {
        return this.value.doubleValue();
    }

    @Override
    public BigDecimal asBigDecimal() {
        return new BigDecimal(this.value);
    }
}

