/*
 * Decompiled with CFR 0.152.
 */
package me.lauriichan.laylib.json;

import java.math.BigDecimal;
import java.math.BigInteger;
import me.lauriichan.laylib.json.IJsonNumber;
import me.lauriichan.laylib.json.JsonType;

public final class JsonBigDecimal
implements IJsonNumber<BigDecimal> {
    private final BigDecimal value;

    public JsonBigDecimal(double value) {
        this.value = BigDecimal.valueOf(value);
    }

    public JsonBigDecimal(BigDecimal value) {
        this.value = value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Number) {
            if (obj instanceof BigDecimal) {
                return this.value.equals(obj);
            }
            if (obj instanceof BigInteger) {
                return this.value.equals(new BigDecimal((BigInteger)obj));
            }
            return this.value.equals(BigDecimal.valueOf(((Number)obj).doubleValue()));
        }
        if (obj instanceof IJsonNumber) {
            return this.value.equals(((IJsonNumber)obj).asBigDecimal());
        }
        return false;
    }

    @Override
    public JsonType type() {
        return JsonType.BIG_DECIMAL;
    }

    @Override
    public BigDecimal value() {
        return this.value;
    }

    @Override
    public byte asByte() {
        return this.value.byteValue();
    }

    @Override
    public short asShort() {
        return this.value.shortValue();
    }

    @Override
    public int asInt() {
        return this.value.intValue();
    }

    @Override
    public long asLong() {
        return this.value.longValue();
    }

    @Override
    public BigInteger asBigInteger() {
        return this.value.toBigInteger();
    }

    @Override
    public float asFloat() {
        return this.value.floatValue();
    }

    @Override
    public double asDouble() {
        return this.value.doubleValue();
    }

    @Override
    public BigDecimal asBigDecimal() {
        return this.value;
    }
}

