/*
 * Decompiled with CFR 0.152.
 */
package me.lauriichan.laylib.json;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;
import me.lauriichan.laylib.json.IJson;
import me.lauriichan.laylib.json.JsonType;

public final class JsonArray
implements IJson<List<IJson<?>>>,
List<IJson<?>>,
RandomAccess {
    private final ObjectArrayList<IJson<?>> list = new ObjectArrayList();

    public boolean addAny(Object object) {
        return this.add(IJson.of(object));
    }

    public void addAny(int index, Object object) {
        this.add(index, IJson.of(object));
    }

    public IJson<?> setAny(int index, Object object) {
        return this.set(index, IJson.of(object));
    }

    public boolean contains(int index, JsonType type) {
        Object value = this.get(index);
        return value == null || !type.hasType((IJson<?>)value);
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof IJson) {
            return this.list.contains(o);
        }
        return this.list.contains(IJson.of(o));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof JsonArray) {
            return this.list.equals(((JsonArray)obj).list);
        }
        if (obj instanceof List) {
            return this.list.equals(obj);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.list.hashCode();
    }

    @Override
    public JsonType type() {
        return JsonType.ARRAY;
    }

    @Override
    public List<IJson<?>> value() {
        return new ObjectArrayList(this.list);
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.list.toArray((Object[])a);
    }

    @Override
    public boolean add(IJson<?> e) {
        return this.list.add(e);
    }

    @Override
    public boolean remove(Object o) {
        if (o instanceof IJson) {
            return this.list.remove(o);
        }
        try {
            return this.list.remove(IJson.of(o));
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.list.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends IJson<?>> c) {
        return this.list.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends IJson<?>> c) {
        return this.list.addAll(index, c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.list.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.list.retainAll(c);
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    @Override
    public IJson<?> get(int index) {
        return (IJson)this.list.get(index);
    }

    @Override
    public IJson<?> set(int index, IJson<?> element) {
        return (IJson)this.list.set(index, element);
    }

    @Override
    public void add(int index, IJson<?> element) {
        this.list.add(index, element);
    }

    @Override
    public IJson<?> remove(int index) {
        return (IJson)this.list.remove(index);
    }

    @Override
    public int indexOf(Object o) {
        if (o instanceof IJson) {
            return this.list.indexOf(o);
        }
        try {
            return this.list.indexOf(IJson.of(o));
        }
        catch (IllegalArgumentException iae) {
            return -1;
        }
    }

    @Override
    public int lastIndexOf(Object o) {
        if (o instanceof IJson) {
            return this.list.lastIndexOf(o);
        }
        try {
            return this.list.lastIndexOf(IJson.of(o));
        }
        catch (IllegalArgumentException iae) {
            return -1;
        }
    }

    @Override
    public ListIterator<IJson<?>> listIterator() {
        return this.list.listIterator();
    }

    @Override
    public ListIterator<IJson<?>> listIterator(int index) {
        return this.list.listIterator(index);
    }

    @Override
    public List<IJson<?>> subList(int fromIndex, int toIndex) {
        return this.list.subList(fromIndex, toIndex);
    }

    @Override
    public Iterator<IJson<?>> iterator() {
        return this.list.iterator();
    }
}

