/*
 * Decompiled with CFR 0.152.
 */
package me.lauriichan.laylib.json;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;
import java.util.Optional;
import me.lauriichan.laylib.json.IJsonNumber;
import me.lauriichan.laylib.json.JsonArray;
import me.lauriichan.laylib.json.JsonBigDecimal;
import me.lauriichan.laylib.json.JsonBigInteger;
import me.lauriichan.laylib.json.JsonBoolean;
import me.lauriichan.laylib.json.JsonByte;
import me.lauriichan.laylib.json.JsonDouble;
import me.lauriichan.laylib.json.JsonFloat;
import me.lauriichan.laylib.json.JsonInteger;
import me.lauriichan.laylib.json.JsonLong;
import me.lauriichan.laylib.json.JsonNull;
import me.lauriichan.laylib.json.JsonObject;
import me.lauriichan.laylib.json.JsonShort;
import me.lauriichan.laylib.json.JsonString;
import me.lauriichan.laylib.json.JsonType;
import me.lauriichan.laylib.json.util.PrimitiveMapper;

public interface IJson<V> {
    public static final JsonNull NULL = JsonNull.NULL;
    public static final JsonBoolean TRUE = JsonBoolean.TRUE;
    public static final JsonBoolean FALSE = JsonBoolean.FALSE;

    public static JsonBoolean of(boolean state) {
        return state ? TRUE : FALSE;
    }

    public static JsonBoolean of(Boolean state) {
        Objects.requireNonNull(state, "String can't be null");
        return state != false ? TRUE : FALSE;
    }

    public static JsonString of(String string) {
        Objects.requireNonNull(string, "String can't be null");
        return new JsonString(string);
    }

    public static JsonByte of(byte value) {
        return JsonByte.of(value);
    }

    public static JsonByte of(Byte value) {
        Objects.requireNonNull(value, "Byte can't be null");
        return JsonByte.of((byte)value);
    }

    public static JsonShort of(short value) {
        return new JsonShort(value);
    }

    public static JsonShort of(Short value) {
        Objects.requireNonNull(value, "Short can't be null");
        return new JsonShort(value);
    }

    public static JsonInteger of(int value) {
        return new JsonInteger(value);
    }

    public static JsonInteger of(Integer value) {
        Objects.requireNonNull(value, "Integer can't be null");
        return new JsonInteger(value);
    }

    public static JsonLong of(long value) {
        return new JsonLong(value);
    }

    public static JsonLong of(Long value) {
        Objects.requireNonNull(value, "Long can't be null");
        return new JsonLong(value);
    }

    public static JsonBigInteger of(BigInteger value) {
        Objects.requireNonNull(value, "BigInteger can't be null");
        return new JsonBigInteger(value);
    }

    public static JsonFloat of(float value) {
        return new JsonFloat(value);
    }

    public static JsonFloat of(Float value) {
        Objects.requireNonNull(value, "Float can't be null");
        return new JsonFloat(value.floatValue());
    }

    public static JsonDouble of(double value) {
        return new JsonDouble(value);
    }

    public static JsonDouble of(Double value) {
        Objects.requireNonNull(value, "Double can't be null");
        return new JsonDouble(value);
    }

    public static JsonBigDecimal of(BigDecimal value) {
        Objects.requireNonNull(value, "BigDecimal can't be null");
        return new JsonBigDecimal(value);
    }

    public static IJson<?> of(Object object) throws IllegalArgumentException {
        if (object == null) {
            return JsonNull.NULL;
        }
        Class<?> type = PrimitiveMapper.fromPrimitive(object.getClass());
        if (type == Boolean.class) {
            return IJson.of((Boolean)object);
        }
        if (type == Byte.class) {
            return JsonByte.of((byte)((Byte)object));
        }
        if (type == String.class) {
            return new JsonString((String)object);
        }
        if (type == Short.class) {
            return new JsonShort((Short)object);
        }
        if (type == Integer.class) {
            return new JsonInteger((Integer)object);
        }
        if (type == Long.class) {
            return new JsonLong((Long)object);
        }
        if (type == BigInteger.class) {
            return new JsonBigInteger((BigInteger)object);
        }
        if (type == Float.class) {
            return new JsonFloat(((Float)object).floatValue());
        }
        if (type == Double.class) {
            return new JsonDouble((Double)object);
        }
        if (type == BigDecimal.class) {
            return new JsonBigDecimal((BigDecimal)object);
        }
        throw new IllegalArgumentException(String.format("Unsupported object of type %s: %s", type, object));
    }

    public JsonType type();

    public V value();

    default public boolean isJson() {
        return this.type().isType(JsonType.JSON);
    }

    default public boolean isPrimitive() {
        return this.type().isType(JsonType.PRIMITIVE);
    }

    default public boolean isArray() {
        return this.type().isType(JsonType.ARRAY);
    }

    default public JsonArray asJsonArray() {
        return (JsonArray)this;
    }

    default public boolean isObject() {
        return this.type().isType(JsonType.OBJECT);
    }

    default public JsonObject asJsonObject() {
        return (JsonObject)this;
    }

    default public boolean isNull() {
        return this.type().isType(JsonType.NULL);
    }

    default public JsonNull asJsonNull() {
        return (JsonNull)this;
    }

    default public boolean isString() {
        return this.type().isType(JsonType.STRING);
    }

    default public JsonString asJsonString() {
        return (JsonString)this;
    }

    default public boolean isNumber() {
        return this.type().isType(JsonType.NUMBER);
    }

    default public IJsonNumber<?> asJsonNumber() {
        return (IJsonNumber)this;
    }

    default public boolean isBoolean() {
        return this.type().isType(JsonType.BOOLEAN);
    }

    default public JsonBoolean asJsonBoolean() {
        return (JsonBoolean)this;
    }

    default public <J extends IJson<?>> Optional<J> as(Class<J> jsonType) {
        if (jsonType.isAssignableFrom(this.getClass())) {
            return Optional.of(this);
        }
        return Optional.empty();
    }
}

