/*
 * Decompiled with CFR 0.152.
 */
package me.lauriichan.laylib.command.util;

import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;

public final class Option<T> {
    private static final Option<?> EMPTY = new Option();
    private final T value;

    public static <T> Option<T> empty() {
        return EMPTY;
    }

    private Option() {
        this.value = null;
    }

    private Option(T value) {
        this.value = value;
    }

    public static <T> Option<T> of(T value) {
        if (value == null) {
            return Option.empty();
        }
        return new Option<T>(value);
    }

    public Optional<T> asOptional() {
        return Optional.ofNullable(this.value);
    }

    public T get() {
        return this.value;
    }

    public boolean isPresent() {
        return this.value != null;
    }

    public boolean isEmpty() {
        return this.value == null;
    }

    public void ifPresent(Consumer<? super T> action) {
        if (this.isEmpty()) {
            return;
        }
        action.accept(this.value);
    }

    public void ifPresentOrElse(Consumer<? super T> action, Runnable emptyAction) {
        if (this.isEmpty()) {
            emptyAction.run();
            return;
        }
        action.accept(this.value);
    }

    public void ifAbsent(Runnable action) {
        if (this.isPresent()) {
            return;
        }
        action.run();
    }

    public Option<T> filter(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate);
        return this.isPresent() ? (predicate.test(this.value) ? this : Option.empty()) : this;
    }

    public <U> Option<U> map(Function<? super T, ? extends U> mapper) {
        Objects.requireNonNull(mapper);
        return this.isPresent() ? Option.of(mapper.apply(this.value)) : Option.empty();
    }

    public <U> Option<U> flatMap(Function<? super T, ? extends Option<? extends U>> mapper) {
        Objects.requireNonNull(mapper);
        return this.isPresent() ? Objects.requireNonNull(mapper.apply(this.value)) : Option.empty();
    }

    public Option<T> or(Supplier<? extends Option<? extends T>> supplier) {
        Objects.requireNonNull(supplier);
        return this.isPresent() ? this : Objects.requireNonNull(supplier.get());
    }

    public Stream<T> stream() {
        return this.isPresent() ? Stream.of(this.value) : Stream.empty();
    }

    public T orElse(T other) {
        return this.value != null ? this.value : other;
    }

    public T orElseGet(Supplier<? extends T> supplier) {
        return this.isPresent() ? this.value : supplier.get();
    }

    public T orElseRun(Runnable runnable) {
        if (this.isPresent()) {
            return this.value;
        }
        runnable.run();
        return null;
    }

    public T orElseThrow() {
        if (this.isPresent()) {
            return this.value;
        }
        throw new NoSuchElementException("No value present");
    }

    public <X extends Throwable> T orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
        if (this.isPresent()) {
            return this.value;
        }
        throw (Throwable)exceptionSupplier.get();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Option)) {
            return false;
        }
        Option other = (Option)obj;
        return Objects.equals(this.value, other.value);
    }

    public int hashCode() {
        return Objects.hashCode(this.value);
    }

    public String toString() {
        return this.isPresent() ? String.format("Option[%s]", this.value) : "Option.empty";
    }
}

