/*
 * Decompiled with CFR 0.152.
 */
package me.lauriichan.laylib.command.util;

import java.util.Comparator;
import me.lauriichan.laylib.command.ArgumentMap;
import me.lauriichan.laylib.command.EmptyArgumentMap;
import me.lauriichan.laylib.command.IArgumentMap;
import me.lauriichan.laylib.command.NodeArgument;
import me.lauriichan.laylib.command.annotation.Param;
import me.lauriichan.laylib.reflection.ClassUtil;

public final class NodeHelper {
    private static final Comparator<? super NodeArgument> SORTER = new Comparator<NodeArgument>(){

        @Override
        public int compare(NodeArgument o1, NodeArgument o2) {
            int rc = Boolean.compare(o1.isProvided(), o2.isProvided());
            if (rc != 0) {
                return rc;
            }
            return Integer.compare(o1.getIndex(), o2.getIndex());
        }
    };
    private static final Comparator<? super NodeArgument> SORTER_OPTIONAL_LAST = new Comparator<NodeArgument>(){

        @Override
        public int compare(NodeArgument o1, NodeArgument o2) {
            int rc = Boolean.compare(o1.isProvided(), o2.isProvided());
            if (rc != 0) {
                return rc;
            }
            rc = Boolean.compare(o1.isOptional(), o2.isOptional());
            if (rc != 0) {
                return rc;
            }
            return Integer.compare(o1.getIndex(), o2.getIndex());
        }
    };

    private NodeHelper() {
        throw new UnsupportedOperationException();
    }

    public static Comparator<? super NodeArgument> sorter() {
        return SORTER;
    }

    public static Comparator<? super NodeArgument> sorterOptionalLast() {
        return SORTER_OPTIONAL_LAST;
    }

    public static boolean isConstantArgument(Class<?> type) {
        return false;
    }

    public static IArgumentMap paramsToMap(Param[] params) {
        if (params.length == 0) {
            return EmptyArgumentMap.INSTANCE;
        }
        ArgumentMap map = new ArgumentMap();
        block20: for (Param param : params) {
            switch (param.type()) {
                case 0: {
                    map.set(param.name(), param.stringValue());
                    continue block20;
                }
                case 1: {
                    map.set(param.name(), param.booleanValue());
                    continue block20;
                }
                case 2: {
                    map.set(param.name(), param.byteValue());
                    continue block20;
                }
                case 3: {
                    map.set(param.name(), param.shortValue());
                    continue block20;
                }
                case 4: {
                    map.set(param.name(), param.intValue());
                    continue block20;
                }
                case 5: {
                    map.set(param.name(), param.longValue());
                    continue block20;
                }
                case 6: {
                    map.set(param.name(), Float.valueOf(param.floatValue()));
                    continue block20;
                }
                case 7: {
                    map.set(param.name(), param.doubleValue());
                    continue block20;
                }
                case 8: {
                    map.set(param.name(), param.classValue());
                    continue block20;
                }
                case 10: {
                    map.set(param.name(), param.stringArrayValue());
                    continue block20;
                }
                case 11: {
                    map.set(param.name(), param.booleanArrayValue());
                    continue block20;
                }
                case 12: {
                    map.set(param.name(), param.byteArrayValue());
                    continue block20;
                }
                case 13: {
                    map.set(param.name(), param.shortArrayValue());
                    continue block20;
                }
                case 14: {
                    map.set(param.name(), param.intArrayValue());
                    continue block20;
                }
                case 15: {
                    map.set(param.name(), param.longArrayValue());
                    continue block20;
                }
                case 16: {
                    map.set(param.name(), param.floatArrayValue());
                    continue block20;
                }
                case 17: {
                    map.set(param.name(), param.doubleArrayValue());
                    continue block20;
                }
                case 18: {
                    map.set(param.name(), param.classArrayValue());
                    continue block20;
                }
                default: {
                    continue block20;
                }
            }
        }
        if (map.isEmpty()) {
            return EmptyArgumentMap.INSTANCE;
        }
        return map;
    }

    public static Object nullValueFor(Class<?> argumentType) {
        if (ClassUtil.isPrimitiveType(argumentType)) {
            Class complexType = ClassUtil.toComplexType(argumentType);
            if (Number.class.isAssignableFrom(complexType)) {
                return complexType.cast(0);
            }
            if (Boolean.class.isAssignableFrom(complexType)) {
                return complexType.cast(false);
            }
        }
        return null;
    }
}

