/*
 * Decompiled with CFR 0.152.
 */
package me.lauriichan.laylib.command.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.atomic.AtomicBoolean;

public final class LockedList<E>
implements List<E> {
    private final List<E> list;
    private final AtomicBoolean locked;

    public LockedList() {
        this(new ArrayList(), new AtomicBoolean(false));
    }

    public LockedList(List<E> list) {
        this(list, new AtomicBoolean(false));
    }

    public LockedList(E ... array) {
        this(new ArrayList(), new AtomicBoolean(false));
        Collections.addAll(this.list, array);
    }

    private LockedList(List<E> list, AtomicBoolean locked) {
        this.list = list;
        this.locked = locked;
    }

    public boolean isLocked() {
        return this.locked.get();
    }

    public LockedList<E> lock() {
        this.locked.set(true);
        return this;
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.list.contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        return new LockedItr<E>(this.list.iterator(), this.locked);
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.list.toArray(a);
    }

    @Override
    public boolean add(E e) {
        if (this.locked.get()) {
            return false;
        }
        return this.list.add(e);
    }

    @Override
    public boolean remove(Object o) {
        if (this.locked.get()) {
            return false;
        }
        return this.list.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.list.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        if (this.locked.get()) {
            return false;
        }
        return this.list.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        if (this.locked.get()) {
            return false;
        }
        return this.list.addAll(index, c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (this.locked.get()) {
            return false;
        }
        return this.list.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        if (this.locked.get()) {
            return false;
        }
        return this.list.retainAll(c);
    }

    @Override
    public void clear() {
        if (this.locked.get()) {
            return;
        }
        this.list.clear();
    }

    @Override
    public E get(int index) {
        return this.list.get(index);
    }

    @Override
    public E set(int index, E element) {
        if (this.locked.get()) {
            return this.list.get(index);
        }
        return this.list.set(index, element);
    }

    @Override
    public void add(int index, E element) {
        if (this.locked.get()) {
            return;
        }
        this.list.add(index, element);
    }

    @Override
    public E remove(int index) {
        if (this.locked.get()) {
            return this.list.get(index);
        }
        return this.list.remove(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.list.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.list.lastIndexOf(o);
    }

    @Override
    public ListIterator<E> listIterator() {
        return new LockedListItr<E>(this.list.listIterator(), this.locked);
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return new LockedListItr<E>(this.list.listIterator(index), this.locked);
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return new LockedList<E>(this.list.subList(fromIndex, toIndex), this.locked);
    }

    private static final class LockedItr<V>
    implements Iterator<V> {
        private final Iterator<V> iterator;
        private final AtomicBoolean locked;

        public LockedItr(Iterator<V> iterator, AtomicBoolean locked) {
            this.iterator = iterator;
            this.locked = locked;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public void remove() {
            if (this.locked.get()) {
                return;
            }
            this.iterator.remove();
        }

        @Override
        public V next() {
            return this.iterator.next();
        }
    }

    private static final class LockedListItr<V>
    implements ListIterator<V> {
        private final ListIterator<V> iterator;
        private final AtomicBoolean locked;

        public LockedListItr(ListIterator<V> iterator, AtomicBoolean locked) {
            this.iterator = iterator;
            this.locked = locked;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public V next() {
            return this.iterator.next();
        }

        @Override
        public boolean hasPrevious() {
            return this.iterator.hasPrevious();
        }

        @Override
        public V previous() {
            return this.iterator.previous();
        }

        @Override
        public int nextIndex() {
            return this.iterator.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.iterator.previousIndex();
        }

        @Override
        public void remove() {
            if (this.locked.get()) {
                return;
            }
            this.iterator.remove();
        }

        @Override
        public void set(V e) {
            if (this.locked.get()) {
                return;
            }
            this.iterator.set(e);
        }

        @Override
        public void add(V e) {
            if (this.locked.get()) {
                return;
            }
            this.iterator.add(e);
        }
    }
}

