/*
 * Decompiled with CFR 0.152.
 */
package me.lauriichan.laylib.command.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.lauriichan.laylib.command.util.MapUtil;

public final class LevenshteinDistance {
    public static final Comparator<Map.Entry<String, Integer>> SORTER = new DistanceSorter();

    private LevenshteinDistance() {
        throw new UnsupportedOperationException();
    }

    public static final List<Map.Entry<String, Integer>> rankByDistance(String input, String[] selection) {
        return LevenshteinDistance.rank(input, Arrays.stream(selection)).collect(Collectors.toList());
    }

    public static final List<Map.Entry<String, Integer>> rankByDistance(String input, Collection<String> selection) {
        return LevenshteinDistance.rank(input, selection.stream()).collect(Collectors.toList());
    }

    public static final List<Map.Entry<String, Integer>> rankByDistance(String input, int limit, String[] selection) {
        return LevenshteinDistance.rank(input, Arrays.stream(selection)).limit(limit).collect(Collectors.toList());
    }

    public static final List<Map.Entry<String, Integer>> rankByDistance(String input, int limit, Collection<String> selection) {
        return LevenshteinDistance.rank(input, selection.stream()).limit(limit).collect(Collectors.toList());
    }

    private static final Stream<Map.Entry<String, Integer>> rank(String input, Stream<String> stream) {
        return ((Stream)stream.unordered()).map(string -> MapUtil.entry(string, LevenshteinDistance.distance(input, string))).sorted(SORTER);
    }

    public static final int distance(String var1, String var2) {
        char[] chars1 = var1.toCharArray();
        char[] chars2 = var2.toCharArray();
        int[][] matrix = new int[chars1.length + 1][chars2.length + 1];
        for (int x = 0; x <= chars1.length; ++x) {
            for (int y = 0; y <= chars2.length; ++y) {
                matrix[x][y] = x == 0 ? y : (y == 0 ? x : Math.min(matrix[x - 1][y - 1] + LevenshteinDistance.costOfChar(chars1[x - 1], chars2[y - 1]), Math.min(matrix[x - 1][y] + 1, matrix[x][y - 1] + 1)));
            }
        }
        return matrix[chars1.length][chars2.length];
    }

    private static final int costOfChar(char var1, char var2) {
        if (var1 == var2) {
            return 0;
        }
        return 1;
    }

    private static final class DistanceSorter
    implements Comparator<Map.Entry<String, Integer>> {
        private DistanceSorter() {
        }

        @Override
        public int compare(Map.Entry<String, Integer> o1, Map.Entry<String, Integer> o2) {
            return Integer.compare(o1.getValue(), o2.getValue());
        }
    }
}

