/*
 * Decompiled with CFR 0.152.
 */
package me.lauriichan.laylib.command.exception;

import java.util.Iterator;
import java.util.Map;
import me.lauriichan.laylib.command.exception.NotEnoughArgumentsException;

public final class ArgumentStack
implements Iterable<Map.Entry<String, Class<?>>> {
    private final Object lock = new Object();
    private Object[][] data;
    private int size = 0;
    private final int expand;

    private void expand() {
        Object[][] newData = new Object[this.data.length + this.expand][2];
        System.arraycopy(this.data, 0, newData, 0, this.data.length);
        this.data = newData;
    }

    public ArgumentStack() {
        this(4);
    }

    public ArgumentStack(int expand) {
        this.expand = Math.min(Math.abs(expand), 16);
        this.data = new Object[this.expand][2];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArgumentStack push(String key, Class<?> type) {
        Object object;
        if (this.size == this.data.length) {
            object = this.lock;
            synchronized (object) {
                this.expand();
            }
        }
        object = this.lock;
        synchronized (object) {
            int index = this.size++;
            if (this.data[index] == null) {
                this.data[index] = new Object[2];
            }
            this.data[index][0] = key;
            this.data[index][1] = type;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map.Entry<String, Class<?>> get(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Index " + index + " is not valid in range 0 - " + this.size);
        }
        Object object = this.lock;
        synchronized (object) {
            return new StackEntry(this.data[index]);
        }
    }

    public int size() {
        return this.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<Map.Entry<String, Class<?>>> iterator() {
        StackEntry[] entries;
        Object object = this.lock;
        synchronized (object) {
            entries = new StackEntry[this.size];
            for (int index = 0; index < this.size; ++index) {
                entries[index] = new StackEntry(this.data[index]);
            }
        }
        return new StackIterator(entries);
    }

    public void throwIfPresent() {
        if (this.size == 0) {
            return;
        }
        throw new NotEnoughArgumentsException(this);
    }

    private class StackEntry
    implements Map.Entry<String, Class<?>> {
        private final String key;
        private final Class<?> type;

        public StackEntry(Object[] data) {
            this.key = (String)data[0];
            this.type = (Class)data[1];
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public Class<?> getValue() {
            return this.type;
        }

        @Override
        public Class<?> setValue(Class<?> value) {
            throw new UnsupportedOperationException("setValue is not supported by " + this.getClass().getTypeName());
        }
    }

    private class StackIterator
    implements Iterator<Map.Entry<String, Class<?>>> {
        private final Map.Entry<String, Class<?>>[] entries;
        private int index = 0;

        public StackIterator(Map.Entry<String, Class<?>>[] entries) {
            this.entries = entries;
        }

        @Override
        public boolean hasNext() {
            return this.entries.length != this.index;
        }

        @Override
        public Map.Entry<String, Class<?>> next() {
            return this.entries[this.index++];
        }
    }
}

