/*
 * Decompiled with CFR 0.152.
 */
package me.lauriichan.laylib.command.argument;

import java.util.Objects;
import me.lauriichan.laylib.command.Actor;
import me.lauriichan.laylib.command.IArgumentMap;
import me.lauriichan.laylib.command.IArgumentType;
import me.lauriichan.laylib.command.Suggestions;

public abstract class NumberArgument<E extends Number>
implements IArgumentType<E> {
    public static final byte BYTE_STEP = 1;
    public static final short SHORT_STEP = 1;
    public static final int INTEGER_STEP = 1;
    public static final long LONG_STEP = 1L;
    public static final float FLOAT_STEP = 1.0f;
    public static final double DOUBLE_STEP = 1.0;
    public static final int SUGGESTIONS = 5;
    private static final double DIV_SUGGESTIONS = 5.0;
    private static final double NORM_SUGGESTIONS = Math.ceil(2.5);
    protected final E minimum;
    protected final E maximum;
    protected final E step;

    public NumberArgument(E minimum, E maximum, E step) {
        this.minimum = (Number)Objects.requireNonNull(minimum, "Minimum can't be null");
        this.maximum = (Number)Objects.requireNonNull(maximum, "Maximum can't be null");
        this.step = (Number)Objects.requireNonNull(step, "Step can't be null");
    }

    @Override
    public E parse(Actor<?> actor, String input, IArgumentMap map) throws IllegalArgumentException {
        E value = this.read(input.trim(), map);
        if (this.compare(value, this.minimum) < 0) {
            throw new IllegalArgumentException("Value lower than " + this.minimum.toString());
        }
        if (this.compare(value, this.maximum) > 0) {
            throw new IllegalArgumentException("Value higher than " + this.maximum.toString());
        }
        return value;
    }

    @Override
    public void suggest(Actor<?> actor, String input, Suggestions suggestions, IArgumentMap map) {
        E value;
        try {
            value = this.read(input, map);
        }
        catch (IllegalArgumentException exp) {
            suggestions.suggest(0.6, this.maximum);
            suggestions.suggest(0.4, this.minimum);
            return;
        }
        if (this.compare(value, this.maximum) > 0) {
            E current = this.maximum;
            for (int index = 0; index < 5; ++index) {
                suggestions.suggest((1.0 - (double)index / 5.0) / NORM_SUGGESTIONS, current);
                current = this.subtract(current, this.step);
            }
            return;
        }
        if (this.compare(value, this.minimum) >= 0) {
            return;
        }
        E current = this.minimum;
        for (int index = 0; index < 5; ++index) {
            suggestions.suggest((1.0 - (double)index / 5.0) / NORM_SUGGESTIONS, current);
            current = this.add(current, (Number)this.step);
        }
    }

    protected abstract E read(String var1, IArgumentMap var2) throws IllegalArgumentException;

    protected abstract int compare(E var1, E var2);

    protected abstract E subtract(E var1, E var2);

    protected abstract E add(E var1, Number var2);
}

