/*
 * Decompiled with CFR 0.152.
 */
package me.lauriichan.laylib.command.argument;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import me.lauriichan.laylib.command.Actor;
import me.lauriichan.laylib.command.IArgumentMap;
import me.lauriichan.laylib.command.IArgumentType;
import me.lauriichan.laylib.command.Suggestions;
import me.lauriichan.laylib.command.util.LevenshteinDistance;

public final class BooleanArgument
implements IArgumentType<Boolean> {
    private static final List<String> FALSE = Arrays.asList("no", "off", "false");
    private static final List<String> TRUE = Arrays.asList("yes", "on", "true");
    private static final List<String> ALL = new ArrayList<String>(TRUE);

    @Override
    public Boolean parse(Actor<?> actor, String input, IArgumentMap map) throws IllegalArgumentException {
        if (TRUE.contains(input = input.toLowerCase())) {
            return true;
        }
        if (FALSE.contains(input)) {
            return false;
        }
        throw new IllegalArgumentException("Unknown state");
    }

    @Override
    public void suggest(Actor<?> actor, String input, Suggestions suggestions, IArgumentMap map) {
        List<Map.Entry<String, Integer>> list = LevenshteinDistance.rankByDistance(input.toLowerCase(), ALL);
        double max = list.stream().map(Map.Entry::getValue).collect(Collectors.summingInt(Integer::intValue)).intValue();
        for (int index = 0; index < list.size(); ++index) {
            Map.Entry<String, Integer> entry = list.get(index);
            suggestions.suggest(1.0 - entry.getValue().doubleValue() / max, entry.getKey());
        }
    }

    static {
        ALL.addAll(FALSE);
    }
}

