/*
 * Decompiled with CFR 0.152.
 */
package me.lauriichan.laylib.command;

import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class Suggestions {
    private final ConcurrentHashMap<String, Double> suggestion = new ConcurrentHashMap();

    public void suggest(double score, Object value) {
        if (value == null) {
            return;
        }
        String stringified = value.toString();
        if (this.suggestion.containsKey(stringified)) {
            return;
        }
        this.suggestion.put(stringified, score);
    }

    public void unsuggest(Object value) {
        if (value == null) {
            return;
        }
        this.suggestion.remove(value.toString());
    }

    public boolean hasSuggestions() {
        return !this.suggestion.isEmpty();
    }

    public Map.Entry<String, Double>[] getSuggestions(int depth) {
        if (depth <= 0) {
            return (Map.Entry[])this.suggestion.entrySet().stream().sorted(SuggestionSorter.INSTANCE).toArray(Map.Entry[]::new);
        }
        return (Map.Entry[])this.suggestion.entrySet().stream().sorted(SuggestionSorter.INSTANCE).limit(depth).toArray(Map.Entry[]::new);
    }

    private static final class SuggestionSorter
    implements Comparator<Map.Entry<String, Double>> {
        private static final SuggestionSorter INSTANCE = new SuggestionSorter();

        private SuggestionSorter() {
        }

        @Override
        public int compare(Map.Entry<String, Double> o1, Map.Entry<String, Double> o2) {
            return -Double.compare(o1.getValue(), o2.getValue());
        }
    }
}

