/*
 * Decompiled with CFR 0.152.
 */
package me.lauriichan.laylib.command;

import java.util.HashMap;
import me.lauriichan.laylib.command.Node;
import me.lauriichan.laylib.command.NodeAction;
import me.lauriichan.laylib.command.annotation.Action;
import me.lauriichan.laylib.command.util.Reference;

final class NodeTree {
    private static final String[] EMPTY = new String[0];
    private final HashMap<String, NodeTree> map = new HashMap();
    private final Reference<NodeAction> action = Reference.of();

    NodeTree() {
    }

    public String[] getNames() {
        return (String[])this.map.keySet().toArray(String[]::new);
    }

    public NodeTree getTree(String name) {
        return this.map.get(name);
    }

    public NodeAction getAction() {
        return this.action.get();
    }

    public void add(Action[] actions, NodeAction nodeAction) {
        for (Action action : actions) {
            String fullPath = action.value().trim().replace("  ", " ").toLowerCase();
            if (fullPath.isEmpty()) {
                this.add(0, EMPTY, fullPath, nodeAction);
                continue;
            }
            this.add(0, fullPath.split(" "), fullPath, nodeAction);
        }
    }

    private void add(int index, String[] path, String fullPath, NodeAction action) {
        if (index == path.length) {
            if (this.action.isPresent()) {
                throw new IllegalStateException("Two nodes try to use '" + fullPath + "'!");
            }
            this.action.set(action);
            return;
        }
        String current = path[index];
        NodeTree tree = this.map.get(current);
        if (tree == null) {
            tree = new NodeTree();
            this.map.put(current, tree);
        }
        tree.add(index + 1, path, fullPath, action);
    }

    public Node build(String name) {
        Node node = new Node(name, this.action.get());
        this.append(node);
        return node;
    }

    private void append(Node node) {
        for (String current : this.map.keySet()) {
            this.map.get(current).append(node, current);
        }
    }

    private void append(Node parent, String name) {
        Node node = parent.putNode(name, this.action.get());
        if (node == null) {
            return;
        }
        this.append(node);
    }
}

