/*
 * Decompiled with CFR 0.152.
 */
package me.lauriichan.laylib.command;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.List;
import me.lauriichan.laylib.command.NodeArgument;
import me.lauriichan.laylib.command.annotation.Description;
import me.lauriichan.laylib.command.annotation.Permission;
import me.lauriichan.laylib.reflection.ClassUtil;

public final class NodeAction {
    private final Method method;
    private final List<NodeArgument> arguments;
    private final String description;
    private final String permission;

    NodeAction(Method method, List<NodeArgument> arguments) {
        this.method = method;
        this.arguments = arguments;
        Description descriptionInfo = (Description)ClassUtil.getAnnotation((AnnotatedElement)method, Description.class);
        this.description = descriptionInfo == null ? "N/A" : descriptionInfo.value();
        Permission permissionInfo = (Permission)ClassUtil.getAnnotation((AnnotatedElement)method, Permission.class);
        this.permission = permissionInfo == null ? null : permissionInfo.value();
    }

    public String getDescription() {
        return this.description;
    }

    public String getPermission() {
        return this.permission;
    }

    public boolean isRestricted() {
        return this.permission != null;
    }

    public Method getMethod() {
        return this.method;
    }

    public List<NodeArgument> getArguments() {
        return this.arguments;
    }

    public int getArgumentCount() {
        return this.arguments.size();
    }
}

