/*
 * Decompiled with CFR 0.152.
 */
package me.lauriichan.laylib.command;

import java.util.HashMap;
import me.lauriichan.laylib.command.NodeAction;

public final class Node {
    private final Node parent;
    private final String name;
    private final NodeAction action;
    private final HashMap<String, Node> map = new HashMap();

    Node(String name) {
        this(null, name, null);
    }

    Node(Node parent, String name) {
        this(parent, name, null);
    }

    Node(String name, NodeAction action) {
        this(null, name, action);
    }

    Node(Node parent, String name, NodeAction action) {
        this.parent = parent;
        this.name = name;
        this.action = action;
    }

    public Node getParent() {
        return this.parent;
    }

    public Node getRoot() {
        if (this.parent == null) {
            return this;
        }
        return this.parent.getRoot();
    }

    public String getName() {
        return this.name;
    }

    public NodeAction getAction() {
        return this.action;
    }

    public Node getNode(String name) {
        return this.map.get(name);
    }

    Node putNode(String name, NodeAction action) {
        if (this.map.containsKey(name)) {
            return null;
        }
        Node node = new Node(this, name, action);
        this.map.put(name, node);
        return node;
    }

    public String[] getNames() {
        return (String[])this.map.keySet().toArray(String[]::new);
    }

    public boolean hasChildren() {
        return !this.map.isEmpty();
    }
}

