/*
 * Decompiled with CFR 0.152.
 */
package me.lauriichan.laylib.command;

import me.lauriichan.laylib.command.Actor;
import me.lauriichan.laylib.command.EmptyArgumentMap;
import me.lauriichan.laylib.command.IArgumentMap;
import me.lauriichan.laylib.command.NodeAction;
import me.lauriichan.laylib.command.NodeArgument;
import me.lauriichan.laylib.command.util.NodeHelper;

public final class CommandProcess {
    private final String label;
    private final NodeAction action;
    private final Object instance;
    private final Object[] values;
    private int index = 0;
    private boolean executed = false;

    public CommandProcess(String label, NodeAction action, Object instance) {
        this.label = label;
        this.action = action;
        this.instance = instance;
        this.values = new Object[action.getArgumentCount()];
    }

    void executed() {
        this.executed = true;
    }

    public NodeArgument findNext(Actor<?> actor) {
        return this.findNext(actor, EmptyArgumentMap.INSTANCE);
    }

    public NodeArgument findNext(Actor<?> actor, IArgumentMap map) {
        while (this.index < this.values.length) {
            NodeArgument argument = this.action.getArguments().get(this.index);
            if (!argument.isProvided()) {
                return argument;
            }
            this.values[argument.getArgumentIndex()] = argument.getType().parse(actor, null, map);
            ++this.index;
        }
        return null;
    }

    public boolean skip(Actor<?> actor) {
        NodeArgument argument = this.findNext(actor);
        if (argument != null && argument.isOptional()) {
            this.values[argument.getArgumentIndex()] = NodeHelper.nullValueFor(argument.getArgumentType());
            ++this.index;
            return true;
        }
        return false;
    }

    public void provide(Actor<?> actor, String input, IArgumentMap map) {
        NodeArgument argument = this.findNext(actor);
        if (argument == null) {
            return;
        }
        this.values[argument.getArgumentIndex()] = argument.getType().parse(actor, input, map);
        ++this.index;
    }

    public void provide(Actor<?> actor, String input) {
        this.provide(actor, input, EmptyArgumentMap.INSTANCE);
    }

    public String getLabel() {
        return this.label;
    }

    public NodeAction getAction() {
        return this.action;
    }

    public Object[] getValues() {
        return this.values;
    }

    public int getIndex() {
        return this.index;
    }

    public Object getInstance() {
        return this.instance;
    }

    public boolean isExecuted() {
        return this.executed;
    }
}

