/*
 * Decompiled with CFR 0.152.
 */
package me.lauriichan.laylib.command;

import java.lang.reflect.Method;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import me.lauriichan.laylib.command.Action;
import me.lauriichan.laylib.command.Actor;
import me.lauriichan.laylib.command.ArgumentRegistry;
import me.lauriichan.laylib.command.CommandProcess;
import me.lauriichan.laylib.command.EmptyArgumentMap;
import me.lauriichan.laylib.command.IArgumentMap;
import me.lauriichan.laylib.command.ICommandInjector;
import me.lauriichan.laylib.command.Node;
import me.lauriichan.laylib.command.NodeAction;
import me.lauriichan.laylib.command.NodeArgument;
import me.lauriichan.laylib.command.NodeCommand;
import me.lauriichan.laylib.command.Suggestions;
import me.lauriichan.laylib.command.argument.provider.CommandManagerProvider;
import me.lauriichan.laylib.command.util.LockedList;
import me.lauriichan.laylib.command.util.Reference;
import me.lauriichan.laylib.command.util.Triple;
import me.lauriichan.laylib.localization.Key;
import me.lauriichan.laylib.logger.ISimpleLogger;
import me.lauriichan.laylib.reflection.ClassUtil;
import me.lauriichan.laylib.reflection.JavaAccess;

public final class CommandManager {
    private static final DecimalFormat PERCENTAGE = new DecimalFormat("0.00%");
    private final ArgumentRegistry registry;
    private final ConcurrentHashMap<String, NodeCommand> commands = new ConcurrentHashMap();
    private final ConcurrentHashMap<UUID, CommandProcess> processes = new ConcurrentHashMap();
    private final Reference<ICommandInjector> injector = Reference.of();
    private final ISimpleLogger logger;
    private String prefix = "/";

    public CommandManager() {
        this(ISimpleLogger.NOP, new ArgumentRegistry());
    }

    public CommandManager(ArgumentRegistry registry) {
        this(ISimpleLogger.NOP, registry);
    }

    public CommandManager(ISimpleLogger logger) {
        this(logger, new ArgumentRegistry());
    }

    public CommandManager(ISimpleLogger logger, ArgumentRegistry registry) {
        this.logger = Objects.requireNonNull(logger, "Logger can't be null!");
        this.registry = Objects.requireNonNull(registry, "Registry can't be null!");
        registry.setProvider(new CommandManagerProvider(this));
    }

    public ArgumentRegistry getRegistry() {
        return this.registry;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public ISimpleLogger getLogger() {
        return this.logger;
    }

    public CommandManager setInjector(ICommandInjector injector) {
        this.injector.set(injector);
        return this;
    }

    public ICommandInjector getInjector() {
        return this.injector.get();
    }

    public CommandProcess cancelProcess(Actor<?> actor) {
        CommandProcess process = this.processes.remove(actor.getId());
        if (process == null) {
            actor.sendTranslatedMessage("command.process.cancel.unavailable", new Key[0]);
            return null;
        }
        actor.sendTranslatedMessage("command.process.cancel.success", Key.of((String)"command", (Object)process.getLabel()));
        return process;
    }

    public CommandProcess createProcess(Actor<?> actor, String label, String[] args) {
        args = (String[])Arrays.stream(args).filter(Predicate.not(String::isBlank)).toArray(String[]::new);
        NodeCommand command = this.getCommand(label);
        if (command == null) {
            actor.sendTranslatedMessage("command.process.create.no-command", Key.of((String)"label", (Object)label));
            return null;
        }
        if (command.isRestricted() && !actor.hasPermission(command.getPermission())) {
            actor.sendTranslatedMessage("command.process.not-permitted", Key.of((String)"permission", (Object)command.getPermission()));
            return null;
        }
        Map.Entry<Node, String> nodePack = this.findNode(command.getNode(), this.prefix + label.toLowerCase(), 0, args);
        Node node = nodePack.getKey();
        if (node.getAction() == null) {
            actor.sendTranslatedMessage("command.process.create.no-action", Key.of((String)"command", (Object)nodePack.getValue()));
            return null;
        }
        NodeAction action = node.getAction();
        if (action.isRestricted() && !actor.hasPermission(action.getPermission())) {
            actor.sendTranslatedMessage("command.process.not-permitted", Key.of((String)"permission", (Object)action.getPermission()));
            return null;
        }
        CommandProcess process = new CommandProcess(nodePack.getValue(), action, command.getInstance());
        NodeArgument argument = process.findNext(actor);
        if (argument == null) {
            this.executeProcess(actor, process);
            return process;
        }
        this.processes.put(actor.getId(), process);
        actor.sendTranslatedMessage("command.process.create.success", Key.of((String)"command", (Object)nodePack.getValue()));
        this.sendNodeInfo(actor, process, argument);
        return process;
    }

    public void handleProcessSkip(Actor<?> actor, CommandProcess process) {
        int index = process.getIndex();
        if (!process.skip(actor)) {
            actor.sendTranslatedMessage("command.process.skip.unskippable", Key.of((String)"command", (Object)process.getLabel()), Key.of((String)"argument", (Object)process.getAction().getArguments().get(process.getIndex()).getName()));
            return;
        }
        NodeArgument argument = process.getAction().getArguments().get(index);
        actor.sendTranslatedMessage("command.process.skip.success", Key.of((String)"command", (Object)process.getLabel()), Key.of((String)"argument", (Object)argument.getName()));
        argument = process.findNext(actor);
        if (argument == null) {
            this.executeProcess(actor, process);
            return;
        }
        this.sendNodeInfo(actor, process, argument);
    }

    public void handleProcessInput(Actor<?> actor, CommandProcess process, String input) {
        this.handleProcessInput(actor, process, input, EmptyArgumentMap.INSTANCE, false);
    }

    public void handleProcessInput(Actor<?> actor, CommandProcess process, String input, IArgumentMap map) {
        this.handleProcessInput(actor, process, input, map, false);
    }

    public void handleProcessInput(Actor<?> actor, CommandProcess process, String input, boolean suggestion) {
        this.handleProcessInput(actor, process, input, EmptyArgumentMap.INSTANCE, suggestion);
    }

    public void handleProcessInput(Actor<?> actor, CommandProcess process, String input, IArgumentMap map, boolean suggestion) {
        if (input == null) {
            return;
        }
        if (suggestion) {
            actor.sendTranslatedMessage("command.process.input.suggestion", Key.of((String)"input", (Object)input));
        } else {
            actor.sendTranslatedMessage("command.process.input.user", Key.of((String)"input", (Object)input));
        }
        try {
            process.provide(actor, input);
        }
        catch (IllegalArgumentException exp) {
            NodeArgument argument = process.findNext(actor);
            if (argument == null) {
                this.executeProcess(actor, process);
                return;
            }
            actor.sendTranslatedMessage("command.process.input.failed", Key.of((String)"error", (Object)exp.getMessage()), Key.of((String)"argument.type", (Object)ClassUtil.getClassName(argument.getArgumentType())));
            Suggestions suggestions = new Suggestions();
            argument.getType().suggest(actor, input, suggestions, map);
            if (!suggestions.hasSuggestions()) {
                return;
            }
            Map.Entry<String, Double>[] entries = suggestions.getSuggestions(5);
            if (entries.length == 0) {
                return;
            }
            actor.sendTranslatedMessage("command.process.suggest.header", new Key[0]);
            for (Map.Entry<String, Double> entry : entries) {
                actor.actionMessageBuilder().message("command.process.suggest.format", Key.of((String)"certainty", (Object)PERCENTAGE.format(entry.getValue())), Key.of((String)"suggestion", (Object)entry.getKey())).action(Action.run("/suggestion " + entry.getKey())).actionHover("command.process.suggest.hover", new Key[0]).send(actor);
            }
            return;
        }
        NodeArgument argument = process.findNext(actor);
        if (argument == null) {
            this.executeProcess(actor, process);
            return;
        }
        this.sendNodeInfo(actor, process, argument);
    }

    public void sendProcessInfo(Actor<?> actor, CommandProcess process) {
        if (process == null) {
            return;
        }
        this.sendNodeInfo(actor, process, process.findNext(actor));
    }

    private void sendNodeInfo(Actor<?> actor, CommandProcess process, NodeArgument argument) {
        actor.sendTranslatedMessage("command.process.argument.specify", Key.of((String)"argument.name", (Object)argument.getName()), Key.of((String)"argument.type", (Object)argument.getArgumentType().getSimpleName()));
        actor.actionMessageBuilder().message("command.process.argument.cancelable.message", new Key[0]).action(Action.run("/cancel")).actionHover("command.process.argument.cancelable.hover", new Key[0]).send(actor);
        if (argument.isOptional()) {
            actor.actionMessageBuilder().message("command.process.argument.optional.message", new Key[0]).action(Action.run("/skip")).actionHover("command.process.argument.optional.hover", new Key[0]).send(actor);
        }
    }

    public boolean executeProcess(Actor<?> actor, CommandProcess process) {
        if (process == null || process.findNext(actor) != null) {
            return false;
        }
        process.executed();
        this.processes.remove(actor.getId());
        NodeAction action = process.getAction();
        if (action.isRestricted() && !actor.hasPermission(action.getPermission())) {
            actor.sendTranslatedMessage("command.process.not-permitted", Key.of((String)"permission", (Object)action.getPermission()));
            return true;
        }
        try {
            JavaAccess.invokeThrows((Object)process.getInstance(), (Method)action.getMethod(), (Object[])process.getValues());
        }
        catch (Throwable e) {
            actor.sendTranslatedMessage("command.process.execution.failed", Key.of((String)"command", (Object)process.getLabel()), Key.of((String)"error", (Object)e.getMessage()));
            this.logger.debug("Failed to execute command '{0}'", e, new Object[]{process.getLabel()});
        }
        return true;
    }

    public CommandProcess getProcess(UUID id) {
        return this.processes.get(id);
    }

    public boolean register(Class<?> clazz) {
        NodeCommand command = new NodeCommand(clazz, this.logger, this.registry);
        if (this.commands.containsKey(command.getName())) {
            return false;
        }
        LockedList<String> list = command.getAliases();
        for (int index = 0; index < list.size(); ++index) {
            String name = list.get(index);
            if (!this.commands.containsKey(name)) {
                this.commands.put(name, command);
                continue;
            }
            list.remove(index--);
        }
        list.lock();
        this.commands.put(command.getName(), command);
        if (this.injector.isPresent()) {
            this.injector.get().inject(command);
        }
        return true;
    }

    public boolean unregister(String name) {
        NodeCommand command = this.commands.remove(name);
        if (command == null) {
            return false;
        }
        for (String alias : command.getAliases()) {
            this.commands.remove(alias);
        }
        if (this.injector.isPresent()) {
            this.injector.get().uninject(command);
        }
        return true;
    }

    public NodeCommand getCommand(String name) {
        return this.commands.get(name.toLowerCase());
    }

    public List<NodeCommand> getCommands() {
        return this.commands.values().stream().distinct().collect(Collectors.toList());
    }

    public String[] getCommandNames() {
        return (String[])this.commands.keySet().toArray(String[]::new);
    }

    public Triple<NodeCommand, Node, String> findNode(String commandString) {
        String[] tmp = (String[])Arrays.stream(commandString.split(" ")).filter(Predicate.not(String::isBlank)).toArray(String[]::new);
        if (tmp.length == 0) {
            return null;
        }
        String label = tmp[0];
        NodeCommand command = this.getCommand(label);
        if (command == null) {
            return null;
        }
        String[] args = new String[tmp.length - 1];
        System.arraycopy(tmp, 1, args, 0, args.length);
        Map.Entry<Node, String> entry = this.findNode(command.getNode(), this.prefix + label.toLowerCase(), 0, args);
        return Triple.of(command, entry.getKey(), entry.getValue());
    }

    public Triple<NodeCommand, Node, String> findNode(String label, String pathRaw) {
        NodeCommand command = this.getCommand(label);
        if (command == null) {
            return null;
        }
        Map.Entry<Node, String> entry = this.findNode(command.getNode(), this.prefix + label.toLowerCase(), 0, (String[])Arrays.stream(pathRaw.split(" ")).filter(Predicate.not(String::isBlank)).toArray(String[]::new));
        return Triple.of(command, entry.getKey(), entry.getValue());
    }

    public Triple<NodeCommand, Node, String> findNode(String label, String[] path) {
        NodeCommand command = this.getCommand(label);
        if (command == null) {
            return null;
        }
        Map.Entry<Node, String> entry = this.findNode(command.getNode(), this.prefix + label.toLowerCase(), 0, (String[])Arrays.stream(path).filter(Predicate.not(String::isBlank)).toArray(String[]::new));
        return Triple.of(command, entry.getKey(), entry.getValue());
    }

    private Map.Entry<Node, String> findNode(Node node, String label, int index, String[] path) {
        Node parent = node;
        while (index != path.length) {
            String current;
            Node found;
            if ((found = parent.getNode(current = path[index++].toLowerCase())) == null) {
                return Map.entry(parent, label);
            }
            parent = found;
            label = (String)label + " " + current;
        }
        return Map.entry(parent, label);
    }
}

