/*
 * Decompiled with CFR 0.152.
 */
package me.lauriichan.laylib.command;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import me.lauriichan.laylib.command.EmptyArgumentMap;
import me.lauriichan.laylib.command.IArgumentMap;
import me.lauriichan.laylib.command.IArgumentType;
import me.lauriichan.laylib.command.IProviderArgumentType;
import me.lauriichan.laylib.command.argument.BooleanArgument;
import me.lauriichan.laylib.command.argument.ByteArgument;
import me.lauriichan.laylib.command.argument.DoubleArgument;
import me.lauriichan.laylib.command.argument.EnumArgument;
import me.lauriichan.laylib.command.argument.FloatArgument;
import me.lauriichan.laylib.command.argument.IntegerArgument;
import me.lauriichan.laylib.command.argument.LongArgument;
import me.lauriichan.laylib.command.argument.ShortArgument;
import me.lauriichan.laylib.command.argument.StringArgument;
import me.lauriichan.laylib.command.argument.provider.ActorProvider;
import me.lauriichan.laylib.command.exception.NotEnoughArgumentsException;
import me.lauriichan.laylib.reflection.ClassUtil;
import me.lauriichan.laylib.reflection.JavaAccess;

public final class ArgumentRegistry {
    private final ConcurrentHashMap<Class<?>, IProviderArgumentType<?>> providerType = new ConcurrentHashMap();
    private final ArrayList<Class<?>> provided = new ArrayList();
    private final HashMap<Class<?>, ArgumentBuilder<?>> argumentTypes = new HashMap();
    private final ArrayList<Class<?>> types = new ArrayList();

    public ArgumentRegistry() {
        this.registerArgumentType(BooleanArgument.class);
        this.registerArgumentType(ByteArgument.class);
        this.registerArgumentType(ShortArgument.class);
        this.registerArgumentType(IntegerArgument.class);
        this.registerArgumentType(LongArgument.class);
        this.registerArgumentType(FloatArgument.class);
        this.registerArgumentType(DoubleArgument.class);
        this.registerArgumentType(StringArgument.class);
        this.registerArgumentType(EnumArgument.class);
        this.setProvider(ActorProvider.PROVIDER);
    }

    public void setProvider(IProviderArgumentType<?> provider) {
        if (provider == null) {
            return;
        }
        Class<?> type = this.extractGenericType(provider.getClass());
        if (type == null) {
            return;
        }
        if (!this.provided.contains(type)) {
            this.provided.add(type);
        }
        this.providerType.put(type, provider);
    }

    public IProviderArgumentType<?> getProvider(Class<?> clazz) {
        IProviderArgumentType<?> type = this.providerType.get(clazz);
        if (type != null) {
            return type;
        }
        for (int index = 0; index < this.provided.size(); ++index) {
            Class<?> current = this.provided.get(index);
            if (!current.isAssignableFrom(clazz)) continue;
            return this.providerType.get(current);
        }
        return null;
    }

    public <V> boolean registerArgumentType(Class<? extends IArgumentType<V>> type) {
        if (type == null || IProviderArgumentType.class.isAssignableFrom(type) || type.isInterface() || Modifier.isAbstract(type.getModifiers())) {
            return false;
        }
        Class<?> argumentType = this.extractGenericType(type);
        if (argumentType == null || this.types.contains(argumentType)) {
            return false;
        }
        this.types.add(argumentType);
        this.argumentTypes.put(argumentType, new ArgumentBuilder(type));
        return true;
    }

    public ArgumentBuilder<?> getArgumentType(Class<?> type) {
        ArgumentBuilder<?> builder = this.argumentTypes.get(type = ClassUtil.toComplexType(type));
        if (builder != null) {
            return builder;
        }
        for (int index = 0; index < this.types.size(); ++index) {
            Class<?> current = this.types.get(index);
            if (!current.isAssignableFrom(type)) continue;
            return this.argumentTypes.get(current);
        }
        return null;
    }

    public IArgumentType<?> getArgument(Class<?> type) {
        return this.getArgument(type, null);
    }

    public IArgumentType<?> getArgument(Class<?> type, IArgumentMap map) {
        ArgumentBuilder<?> builder = this.getArgumentType(type);
        if (builder == null) {
            return null;
        }
        return builder.build(map);
    }

    private Class<?> extractGenericType(Class<?> clazz) {
        Type[] interfaces;
        Type superType = clazz.getGenericSuperclass();
        Type[] superTypeArray = superType == null ? new Type[]{} : new Type[]{superType};
        Type[] types = new Type[superTypeArray.length + (interfaces = clazz.getGenericInterfaces()).length];
        if (types.length == 0) {
            return null;
        }
        System.arraycopy(superTypeArray, 0, types, 0, superTypeArray.length);
        System.arraycopy(interfaces, 0, types, superTypeArray.length, interfaces.length);
        for (Type type : types) {
            Class current;
            if (!(type instanceof ParameterizedType) || (current = ClassUtil.findClass((String)((ParameterizedType)type).getRawType().getTypeName())) == null || !IProviderArgumentType.class.isAssignableFrom(current) && !IArgumentType.class.isAssignableFrom(current)) continue;
            Type out = ((ParameterizedType)type).getActualTypeArguments()[0];
            if (out instanceof ParameterizedType) {
                out = ((ParameterizedType)out).getRawType();
            }
            return ClassUtil.findClass((String)out.getTypeName());
        }
        return null;
    }

    public static final class ArgumentBuilder<V> {
        private final Class<? extends IArgumentType<V>> type;
        private final Constructor<?> constructor;
        private final boolean map;

        public ArgumentBuilder(Class<? extends IArgumentType<V>> type) {
            this.type = type;
            Constructor tmp = ClassUtil.getConstructor(type, (Class[])new Class[]{IArgumentMap.class});
            if (tmp != null) {
                this.map = true;
                this.constructor = tmp;
                return;
            }
            this.map = false;
            this.constructor = Objects.requireNonNull(ClassUtil.getConstructor(type, (Class[])new Class[0]), "Valid Constructor can't be found for ArgumentType '" + ClassUtil.getClassName(type) + "'!");
        }

        public Class<? extends IArgumentType<V>> getType() {
            return this.type;
        }

        public Constructor<?> getConstructor() {
            return this.constructor;
        }

        public boolean requiresMap() {
            return this.map;
        }

        public IArgumentType<V> build(IArgumentMap map) throws NotEnoughArgumentsException {
            try {
                if (this.map) {
                    if (map == null) {
                        map = EmptyArgumentMap.INSTANCE;
                    }
                    return this.type.cast(JavaAccess.instanceThrows(this.constructor, (Object[])new Object[]{map}));
                }
                return this.type.cast(JavaAccess.instanceThrows(this.constructor, (Object[])new Object[0]));
            }
            catch (Throwable e) {
                Optional exp = ClassUtil.findException((Throwable)e, NotEnoughArgumentsException.class);
                if (exp.isEmpty()) {
                    return null;
                }
                throw (NotEnoughArgumentsException)exp.get();
            }
        }
    }
}

