/*
 * Decompiled with CFR 0.152.
 */
package me.lauriichan.laylib.command;

import java.util.HashMap;
import java.util.Objects;
import me.lauriichan.laylib.command.IArgumentMap;
import me.lauriichan.laylib.command.util.Option;
import me.lauriichan.laylib.reflection.ClassUtil;

public class ArgumentMap
implements IArgumentMap {
    private final HashMap<String, Object> map = new HashMap();

    @Override
    public boolean has(String key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean has(String key, Class<?> type) {
        Object object = this.map.get(key);
        return object != null && type.isInstance(object);
    }

    @Override
    public Option<Object> get(String key) {
        return Option.of(this.map.get(key));
    }

    @Override
    public <E> Option<E> get(String key, Class<E> type) {
        return this.get(key).filter(object -> type.isAssignableFrom(ClassUtil.toComplexType(object.getClass()))).map(type::cast);
    }

    @Override
    public Option<Class<?>> getClass(String key) {
        return Option.of(this.map.get(key)).filter(val -> val instanceof Class).map(val -> (Class)val);
    }

    @Override
    public <E> Option<Class<? extends E>> getClass(String key, Class<E> abstraction) {
        return this.getClass(key).filter(clazz -> abstraction.isAssignableFrom(ClassUtil.toComplexType((Class)clazz))).map(clazz -> clazz.asSubclass(abstraction));
    }

    @Override
    public ArgumentMap set(String key, Object value) {
        this.map.put(key, Objects.requireNonNull(value));
        return this;
    }

    @Override
    public ArgumentMap remove(String key) {
        this.map.remove(key);
        return this;
    }

    @Override
    public ArgumentMap clear() {
        this.map.clear();
        return this;
    }

    @Override
    public ArgumentMap clone() {
        ArgumentMap clone = new ArgumentMap();
        this.map.putAll(this.map);
        return clone;
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public int size() {
        return this.map.size();
    }
}

