/*
 * Decompiled with CFR 0.152.
 */
package me.lauriichan.laylib.command;

import java.util.UUID;
import me.lauriichan.laylib.command.Action;
import me.lauriichan.laylib.command.ActionMessage;
import me.lauriichan.laylib.localization.IMessage;
import me.lauriichan.laylib.localization.IMessageReceiver;
import me.lauriichan.laylib.localization.Key;
import me.lauriichan.laylib.localization.MessageManager;
import me.lauriichan.laylib.localization.MessageProvider;

public abstract class Actor<P>
implements IMessageReceiver {
    public static final UUID IMPL_ID = new UUID(0L, 0L);
    public static final String DEFAULT_LANGUAGE = "en-uk";
    private static final Actor EMPTY = new Actor((Object)null, null){

        public UUID getId() {
            return null;
        }

        @Override
        public String getLanguage() {
            return null;
        }

        @Override
        public String getName() {
            return null;
        }
    };
    protected final P handle;
    protected final MessageManager messageManager;

    public Actor(P handle, MessageManager messageManager) {
        this.handle = handle;
        this.messageManager = messageManager;
    }

    public final P getHandle() {
        return this.handle;
    }

    public final MessageManager getMessageManager() {
        return this.messageManager;
    }

    public final <C> Actor<C> as(Class<C> type) {
        if (this.handle != null && type.isAssignableFrom(this.handle.getClass())) {
            return this;
        }
        return EMPTY;
    }

    public final boolean isValid() {
        return this.handle != null;
    }

    public abstract String getName();

    public String getLanguage() {
        return DEFAULT_LANGUAGE;
    }

    public String getTranslatedMessageAsString(MessageProvider provider, Key ... placeholders) {
        return this.messageManager.translate(provider, this.getLanguage(), placeholders);
    }

    public String getTranslatedMessageAsString(String messageId, Key ... placeholders) {
        return this.messageManager.translate(messageId, this.getLanguage(), placeholders);
    }

    public IMessage getTranslatedMessage(MessageProvider provider) {
        return provider.getMessage(this.getLanguage());
    }

    public IMessage getTranslatedMessage(String messageId) {
        return this.messageManager.getMessage(messageId, this.getLanguage());
    }

    public void sendMessage(String message) {
    }

    public void sendMessage(IMessage message, Key ... placeholders) {
        this.sendMessage(this.messageManager.format(message, placeholders));
    }

    public void sendTranslatedMessage(MessageProvider provider, Key ... placeholders) {
        this.sendMessage(this.messageManager.translate(provider, this.getLanguage(), placeholders));
    }

    public void sendTranslatedMessage(String messageId, Key ... placeholders) {
        this.sendMessage(this.messageManager.translate(messageId, this.getLanguage(), placeholders));
    }

    public ActionMessage actionMessageBuilder() {
        return new ActionMessage(this);
    }

    public void sendActionMessage(ActionMessage message) {
        this.sendMessage(message.message());
    }

    public final void sendActionMessage(String message, Action ... actions) {
        ActionMessage builder = this.actionMessageBuilder().messageRaw(message);
        for (Action action : actions) {
            builder.action(action);
        }
        this.sendActionMessage(builder);
    }

    public boolean hasPermission(String permission) {
        return false;
    }
}

