/*
 * Decompiled with CFR 0.152.
 */
package me.lauriichan.laylib.command;

import me.lauriichan.laylib.command.Action;
import me.lauriichan.laylib.command.Actor;
import me.lauriichan.laylib.localization.IMessage;
import me.lauriichan.laylib.localization.Key;
import me.lauriichan.laylib.localization.MessageManager;
import me.lauriichan.laylib.localization.MessageProvider;

public final class ActionMessage {
    private Action hoverAction;
    private Action clickAction;
    private String message;
    private final String language;
    private final MessageManager messageManager;

    public ActionMessage(Actor<?> actor) {
        this(actor.getMessageManager(), actor.getLanguage());
    }

    public ActionMessage(MessageManager messageManager, String language) {
        this.messageManager = messageManager;
        this.language = language;
    }

    public ActionMessage action(Action action) {
        if (action.isClick()) {
            this.clickAction = action;
            return this;
        }
        this.hoverAction = action;
        return this;
    }

    public ActionMessage actionHoverRaw(String messageRaw) {
        return this.action(Action.hoverText(messageRaw));
    }

    public ActionMessage actionHover(String messageId, Key ... placholders) {
        return this.actionHoverRaw(this.messageManager.translate(messageId, this.language, placholders));
    }

    public ActionMessage actionHover(MessageProvider messageProvider, Key ... placholders) {
        return this.actionHoverRaw(this.messageManager.translate(messageProvider, this.language, placholders));
    }

    public ActionMessage actionHover(IMessage message, Key ... placholders) {
        return this.actionHoverRaw(this.messageManager.format(message, placholders));
    }

    public ActionMessage messageRaw(String message) {
        this.message = message;
        return this;
    }

    public ActionMessage message(String messageId, Key ... placholders) {
        return this.messageRaw(this.messageManager.translate(messageId, this.language, placholders));
    }

    public ActionMessage message(MessageProvider messageProvider, Key ... placholders) {
        return this.messageRaw(this.messageManager.translate(messageProvider, this.language, placholders));
    }

    public ActionMessage message(IMessage message, Key ... placholders) {
        return this.messageRaw(this.messageManager.format(message, placholders));
    }

    public Action clickAction() {
        return this.clickAction;
    }

    public Action hoverAction() {
        return this.hoverAction;
    }

    public String message() {
        return this.message;
    }

    public void send(Actor<?> actor) {
        actor.sendActionMessage(this);
    }
}

