/*
 * Decompiled with CFR 0.152.
 */
package de.syntaxjason.validation;

import de.syntaxjason.adapter.PersistenceAdapter;
import de.syntaxjason.annotations.Validation;
import de.syntaxjason.core.EntityManager;
import de.syntaxjason.meta.EntityMeta;
import de.syntaxjason.meta.FieldMeta;
import de.syntaxjason.validation.ValidationException;
import de.syntaxjason.validation.ValidationUtil;
import de.syntaxjason.validation.ValidatorService;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public final class DefaultValidator
implements ValidatorService {
    private static final Pattern EMAIL_PATTERN = Pattern.compile("^[^\\s@]+@[^\\s@]+\\.[^\\s@]+$");

    @Override
    public void validate(Object entity, EntityMeta meta) {
        ArrayList<String> errors = new ArrayList<String>();
        for (FieldMeta field : meta.fields()) {
            List<Validation> validations = ValidationUtil.getValidations(meta.type(), field.name());
            for (Validation v : validations) {
                boolean ok = this.applyRule(v, field, entity, meta);
                if (ok) continue;
                errors.add(v.message());
            }
        }
        if (errors.isEmpty()) {
            return;
        }
        throw new ValidationException("Validation failed: " + String.join((CharSequence)"; ", errors));
    }

    private boolean applyRule(Validation validation, FieldMeta field, Object entity, EntityMeta meta) {
        Object value = field.getter().apply(entity);
        if (validation.rule() == Validation.Rule.NOT_NULL) {
            return value != null;
        }
        if (validation.rule() == Validation.Rule.NOT_BLANK) {
            return value != null && value.toString().trim().length() > 0;
        }
        if (validation.rule() == Validation.Rule.MIN_LENGTH) {
            return value != null && value.toString().length() >= this.parseInt(validation.value(), 0);
        }
        if (validation.rule() == Validation.Rule.MAX_LENGTH) {
            return value == null || value.toString().length() <= this.parseInt(validation.value(), Integer.MAX_VALUE);
        }
        if (validation.rule() == Validation.Rule.EMAIL) {
            return value != null && EMAIL_PATTERN.matcher(value.toString()).matches();
        }
        if (validation.rule() == Validation.Rule.UNIQUE) {
            return this.isUnique(meta, field, value, entity);
        }
        return true;
    }

    private boolean isUnique(EntityMeta meta, FieldMeta field, Object value, Object entity) {
        if (value == null) {
            return true;
        }
        PersistenceAdapter adapter = EntityManager.adapter(meta.type());
        List<?> list = adapter.queryByFields(meta, meta.type(), new String[]{field.column()}, new Object[]{value});
        if (list.isEmpty()) {
            return true;
        }
        Object currentId = meta.primaryKeyField().getter().apply(entity);
        if (currentId == null) {
            return false;
        }
        return list.stream().allMatch(found -> {
            Object otherId = meta.primaryKeyField().getter().apply(found);
            return currentId.equals(otherId);
        });
    }

    private int parseInt(String s, int fallback) {
        try {
            return Integer.parseInt(s);
        }
        catch (Exception e) {
            return fallback;
        }
    }
}

