/*
 * Decompiled with CFR 0.152.
 */
package de.syntaxjason.repository;

import de.syntaxjason.core.DatabaseEntity;
import de.syntaxjason.core.EntityManager;
import de.syntaxjason.meta.EntityMeta;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

final class RepositoryInvocationHandler<T>
implements InvocationHandler {
    private final Class<T> entityType;
    private final EntityMeta meta;

    RepositoryInvocationHandler(Class<T> type) {
        this.entityType = type;
        this.meta = EntityManager.meta(type);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if (methodName.equals("save")) {
            return ((DatabaseEntity)args[0]).save();
        }
        if (methodName.equals("update")) {
            return ((DatabaseEntity)args[0]).update();
        }
        if (methodName.equals("delete")) {
            return ((DatabaseEntity)args[0]).delete();
        }
        if (methodName.equals("findById")) {
            return EntityManager.findById(this.entityType, args[0]);
        }
        if (methodName.equals("findAll")) {
            return EntityManager.adapter(this.entityType).findAll(this.meta, this.entityType);
        }
        if (methodName.startsWith("findBy")) {
            return this.derivedQuery(methodName.substring(6), args);
        }
        if (methodName.startsWith("existsBy")) {
            return this.existsQuery(methodName.substring(8), args);
        }
        throw new UnsupportedOperationException("Method not supported: " + methodName);
    }

    private List<T> findAll() {
        return EntityManager.adapter(this.entityType).findAll(this.meta, this.entityType);
    }

    private Object derivedQuery(String descriptor, Object[] args) {
        String[] parts = descriptor.split("And");
        String[] columns = (String[])Arrays.stream(parts).map(this::toColumn).toArray(String[]::new);
        return EntityManager.adapter(this.entityType).queryByFields(this.meta, this.entityType, columns, args);
    }

    private Object existsQuery(String descriptor, Object[] args) {
        List result = (List)this.derivedQuery(descriptor, args);
        return !result.isEmpty();
    }

    private String toColumn(String propertyName) {
        String prop = propertyName.substring(0, 1).toLowerCase(Locale.ROOT) + propertyName.substring(1);
        return this.meta.fields().stream().filter(f -> f.name().equals(prop)).findFirst().map(f -> f.column()).orElseThrow(() -> new IllegalArgumentException("Unknown field: " + prop));
    }
}

