/*
 * Decompiled with CFR 0.152.
 */
package de.syntaxjason.meta;

import de.syntaxjason.annotations.DatabaseField;
import de.syntaxjason.annotations.PrimaryKey;
import de.syntaxjason.types.FieldType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.function.BiConsumer;
import java.util.function.Function;

public final class FieldMeta {
    private final String name;
    private final String column;
    private final boolean nullable;
    private final boolean unique;
    private final boolean indexed;
    private final int maxLength;
    private final FieldType fieldType;
    private final boolean isPrimaryKey;
    private final boolean autoIncrement;
    private final Function<Object, Object> getter;
    private final BiConsumer<Object, Object> setter;

    private FieldMeta(String name, String column, boolean nullable, boolean unique, boolean indexed, int maxLength, FieldType fieldType, boolean isPrimaryKey, boolean autoIncrement, Function<Object, Object> getter, BiConsumer<Object, Object> setter) {
        this.name = name;
        this.column = column;
        this.nullable = nullable;
        this.unique = unique;
        this.indexed = indexed;
        this.maxLength = maxLength;
        this.fieldType = fieldType;
        this.isPrimaryKey = isPrimaryKey;
        this.autoIncrement = autoIncrement;
        this.getter = getter;
        this.setter = setter;
    }

    public static FieldMeta fromField(Class<?> owner, Field field, DatabaseField df, boolean isPk) {
        PrimaryKey pk = field.getAnnotation(PrimaryKey.class);
        String property = field.getName();
        String column = df.column();
        boolean autoInc = pk != null && pk.autoIncrement();
        Function<Object, Object> getter = FieldMeta.findGetter(owner, property);
        BiConsumer<Object, Object> setter = FieldMeta.findSetter(owner, property, field.getType());
        return new FieldMeta(property, column, df.nullable(), df.unique(), df.indexed(), df.maxLength(), df.type(), isPk, autoInc, getter, setter);
    }

    public String name() {
        return this.name;
    }

    public String column() {
        return this.column;
    }

    public boolean nullable() {
        return this.nullable;
    }

    public boolean unique() {
        return this.unique;
    }

    public boolean indexed() {
        return this.indexed;
    }

    public int maxLength() {
        return this.maxLength;
    }

    public FieldType fieldType() {
        return this.fieldType;
    }

    public boolean isPrimaryKey() {
        return this.isPrimaryKey;
    }

    public boolean autoIncrement() {
        return this.autoIncrement;
    }

    public boolean isEncrypted() {
        return this.fieldType == FieldType.ENCRYPTED;
    }

    public Function<Object, Object> getter() {
        return this.getter;
    }

    public BiConsumer<Object, Object> setter() {
        return this.setter;
    }

    public boolean insertable() {
        return !this.isPrimaryKey || !this.autoIncrement;
    }

    public boolean updatable() {
        return !this.isPrimaryKey;
    }

    private static Function<Object, Object> findGetter(Class<?> owner, String property) {
        String base = property.substring(0, 1).toUpperCase(Locale.ROOT) + property.substring(1);
        for (String prefix : new String[]{"get", "is"}) {
            try {
                Method m = owner.getMethod(prefix + base, new Class[0]);
                return o -> {
                    try {
                        return m.invoke(o, new Object[0]);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                };
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
        }
        try {
            Field f = owner.getDeclaredField(property);
            f.setAccessible(true);
            return o -> {
                try {
                    return f.get(o);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            };
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException("Getter not found for " + owner.getName() + "." + property);
        }
    }

    private static BiConsumer<Object, Object> findSetter(Class<?> owner, String property, Class<?> type) {
        String base = property.substring(0, 1).toUpperCase(Locale.ROOT) + property.substring(1);
        try {
            Method m = owner.getMethod("set" + base, type);
            return (o, v) -> {
                try {
                    m.invoke(o, v);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            };
        }
        catch (NoSuchMethodException e) {
            try {
                Field f = owner.getDeclaredField(property);
                f.setAccessible(true);
                return (o, v) -> {
                    try {
                        f.set(o, v);
                    }
                    catch (Exception ex) {
                        throw new RuntimeException(ex);
                    }
                };
            }
            catch (NoSuchFieldException ex) {
                throw new IllegalStateException("Setter not found for " + owner.getName() + "." + property);
            }
        }
    }
}

