/*
 * Decompiled with CFR 0.152.
 */
package de.syntaxjason.meta;

import de.syntaxjason.annotations.DatabaseField;
import de.syntaxjason.annotations.DatabaseTable;
import de.syntaxjason.annotations.Index;
import de.syntaxjason.annotations.Indexes;
import de.syntaxjason.annotations.PrimaryKey;
import de.syntaxjason.meta.FieldMeta;
import de.syntaxjason.meta.IndexMeta;
import de.syntaxjason.types.CacheStrategy;
import de.syntaxjason.types.DatabaseType;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public final class EntityMeta {
    private final Class<?> type;
    private final String tableName;
    private final String primaryKeyColumn;
    private final FieldMeta primaryKeyField;
    private final List<FieldMeta> fields;
    private final List<FieldMeta> insertable;
    private final List<FieldMeta> updatable;
    private final List<IndexMeta> indexes;
    private final DatabaseType[] supported;
    private final CacheStrategy cacheStrategy;

    private EntityMeta(Class<?> type, String tableName, String primaryKeyColumn, FieldMeta primaryKeyField, List<FieldMeta> fields, List<FieldMeta> insertable, List<FieldMeta> updatable, List<IndexMeta> indexes, DatabaseType[] supported, CacheStrategy cacheStrategy) {
        this.type = type;
        this.tableName = tableName;
        this.primaryKeyColumn = primaryKeyColumn;
        this.primaryKeyField = primaryKeyField;
        this.fields = fields;
        this.insertable = insertable;
        this.updatable = updatable;
        this.indexes = indexes;
        this.supported = supported;
        this.cacheStrategy = cacheStrategy;
    }

    public Class<?> type() {
        return this.type;
    }

    public String tableName() {
        return this.tableName;
    }

    public String primaryKeyColumn() {
        return this.primaryKeyColumn;
    }

    public FieldMeta primaryKeyField() {
        return this.primaryKeyField;
    }

    public List<FieldMeta> fields() {
        return this.fields;
    }

    public List<FieldMeta> insertableFields() {
        return this.insertable;
    }

    public List<FieldMeta> updatableFields() {
        return this.updatable;
    }

    public List<IndexMeta> indexes() {
        return this.indexes;
    }

    public DatabaseType[] supportedTypes() {
        return this.supported;
    }

    public CacheStrategy cacheStrategy() {
        return this.cacheStrategy;
    }

    public boolean isSqlite() {
        for (DatabaseType t : this.supported) {
            if (t != DatabaseType.SQLITE) continue;
            return true;
        }
        return false;
    }

    public static EntityMeta fromClass(Class<?> type) {
        Index single;
        DatabaseTable table = type.getAnnotation(DatabaseTable.class);
        if (table == null) {
            throw new IllegalArgumentException("Missing @DatabaseTable on " + type.getName());
        }
        ArrayList<FieldMeta> allFields = new ArrayList<FieldMeta>();
        FieldMeta pkField = null;
        for (Field field : type.getDeclaredFields()) {
            Index[] dbf = field.getAnnotation(DatabaseField.class);
            if (dbf == null) continue;
            boolean isPk = field.isAnnotationPresent(PrimaryKey.class);
            FieldMeta meta = FieldMeta.fromField(type, field, (DatabaseField)dbf, isPk);
            allFields.add(meta);
            if (!isPk) continue;
            pkField = meta;
        }
        if (pkField == null) {
            throw new IllegalArgumentException("Primary key required on " + type.getName());
        }
        List<FieldMeta> insertable = allFields.stream().filter(FieldMeta::insertable).collect(Collectors.toList());
        List<FieldMeta> updatable = allFields.stream().filter(FieldMeta::updatable).collect(Collectors.toList());
        ArrayList<IndexMeta> idxs = new ArrayList<IndexMeta>();
        Indexes container = type.getAnnotation(Indexes.class);
        if (container != null) {
            for (Index ix : container.value()) {
                idxs.add(IndexMeta.from(ix));
            }
        }
        if ((single = type.getAnnotation(Index.class)) != null) {
            idxs.add(IndexMeta.from(single));
        }
        for (Field field : type.getDeclaredFields()) {
            Index fieldIndex = field.getAnnotation(Index.class);
            if (fieldIndex == null) continue;
            String column = Optional.ofNullable(field.getAnnotation(DatabaseField.class)).map(DatabaseField::column).orElse(field.getName());
            idxs.add(IndexMeta.from(fieldIndex, column));
        }
        for (FieldMeta f : allFields) {
            if (!f.indexed()) continue;
            idxs.add(new IndexMeta("idx_" + f.column(), new String[]{f.column()}, f.unique(), "BTREE"));
        }
        return new EntityMeta(type, table.name(), pkField.column(), pkField, allFields, insertable, updatable, idxs, table.supportedTypes(), table.cacheStrategy());
    }
}

