/*
 * Decompiled with CFR 0.152.
 */
package de.syntaxjason.mapper;

import de.syntaxjason.crypto.CryptoRegistry;
import de.syntaxjason.meta.EntityMeta;
import de.syntaxjason.meta.FieldMeta;
import de.syntaxjason.types.FieldType;
import java.lang.reflect.Constructor;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;

public final class RowMapper {
    public <T> T mapRow(ResultSet rs, EntityMeta meta, Class<T> type) {
        T instance = this.instantiate(type);
        for (FieldMeta field : meta.fields()) {
            Object raw = this.readValue(rs, field);
            if (field.isEncrypted()) {
                String cipher = raw == null ? null : String.valueOf(raw);
                raw = CryptoRegistry.getCryptoService().decrypt(cipher);
            }
            field.setter().accept(instance, raw);
        }
        return instance;
    }

    private <T> T instantiate(Class<T> type) {
        try {
            Constructor<T> ctor = type.getDeclaredConstructor(new Class[0]);
            ctor.setAccessible(true);
            return ctor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to instantiate " + type.getName(), e);
        }
    }

    private Object readValue(ResultSet rs, FieldMeta field) {
        try {
            if (field.fieldType() == FieldType.TIMESTAMP) {
                Timestamp ts = rs.getTimestamp(field.column());
                if (ts == null) {
                    return null;
                }
                LocalDateTime ldt = ts.toLocalDateTime();
                return ldt;
            }
            return rs.getObject(field.column());
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to read column " + field.column(), e);
        }
    }
}

