/*
 * Decompiled with CFR 0.152.
 */
package de.syntaxjason.mapper;

import de.syntaxjason.crypto.CryptoRegistry;
import de.syntaxjason.meta.EntityMeta;
import de.syntaxjason.meta.FieldMeta;
import de.syntaxjason.types.FieldType;
import java.lang.reflect.Constructor;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Date;
import org.bson.Document;

public final class DocumentMapper {
    public Document toDocument(EntityMeta meta, Object entity) {
        Document document = new Document();
        for (FieldMeta field : meta.fields()) {
            Object value = field.getter().apply(entity);
            if (field.isPrimaryKey()) {
                if (value == null) continue;
                document.put("_id", value);
                continue;
            }
            if (field.isEncrypted()) {
                String plain = value == null ? null : String.valueOf(value);
                value = CryptoRegistry.getCryptoService().encrypt(plain);
            }
            if (field.fieldType() == FieldType.TIMESTAMP && value instanceof LocalDateTime) {
                LocalDateTime ldt = (LocalDateTime)value;
                Date date = Date.from(ldt.toInstant(ZoneOffset.UTC));
                document.put(field.column(), (Object)date);
                continue;
            }
            document.put(field.column(), value);
        }
        return document;
    }

    public <T> T fromDocument(Document doc, EntityMeta meta, Class<T> type) {
        T instance = this.instantiate(type);
        Object id = doc.get((Object)"_id");
        if (id != null) {
            meta.primaryKeyField().setter().accept(instance, id);
        }
        for (FieldMeta field : meta.fields()) {
            if (field.isPrimaryKey()) continue;
            Object value = doc.get((Object)field.column());
            if (field.fieldType() == FieldType.TIMESTAMP && value instanceof Date) {
                Date date = (Date)value;
                LocalDateTime ldt = LocalDateTime.ofInstant(date.toInstant(), ZoneOffset.UTC);
                field.setter().accept(instance, ldt);
                continue;
            }
            if (field.isEncrypted()) {
                String cipher = value == null ? null : String.valueOf(value);
                value = CryptoRegistry.getCryptoService().decrypt(cipher);
            }
            field.setter().accept(instance, value);
        }
        return instance;
    }

    private <T> T instantiate(Class<T> type) {
        try {
            Constructor<T> ctor = type.getDeclaredConstructor(new Class[0]);
            ctor.setAccessible(true);
            return ctor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to instantiate " + type.getName(), e);
        }
    }
}

