/*
 * Decompiled with CFR 0.152.
 */
package de.syntaxjason.dialect;

import de.syntaxjason.meta.EntityMeta;
import de.syntaxjason.meta.FieldMeta;
import de.syntaxjason.types.FieldType;
import java.util.StringJoiner;

public final class SqlDialectUtil {
    private SqlDialectUtil() {
    }

    public static String createTableSql(EntityMeta meta, String tableSuffix) {
        StringJoiner columns = new StringJoiner(", ");
        for (FieldMeta field : meta.fields()) {
            String definition = field.column() + " " + SqlDialectUtil.sqlType(field);
            if (!field.nullable()) {
                definition = definition + " NOT NULL";
            }
            if (field.unique()) {
                definition = definition + " UNIQUE";
            }
            if (field.isPrimaryKey() && field.autoIncrement() && meta.isSqlite()) {
                definition = definition + " PRIMARY KEY AUTOINCREMENT";
            }
            columns.add(definition);
        }
        String pkClause = meta.isSqlite() ? "" : (meta.primaryKeyColumn() != null ? ", PRIMARY KEY (" + meta.primaryKeyColumn() + ")" : "");
        Object suffix = tableSuffix != null ? " " + tableSuffix : "";
        return "CREATE TABLE IF NOT EXISTS " + meta.tableName() + " (" + String.valueOf(columns) + pkClause + ")" + (String)suffix + ";";
    }

    public static String createIndexSql(String dialect, String table, String name, String[] fields, boolean unique, String type) {
        String using;
        String uq = unique ? "UNIQUE " : "";
        String string = using = type != null && !type.isBlank() ? " USING " + type : "";
        if ("sqlite".equalsIgnoreCase(dialect)) {
            using = "";
        }
        return "CREATE " + uq + "INDEX IF NOT EXISTS " + name + " ON " + table + using + " (" + String.join((CharSequence)", ", fields) + ");";
    }

    public static String delete(EntityMeta meta) {
        return "DELETE FROM " + meta.tableName() + " WHERE " + meta.primaryKeyColumn() + " = ?;";
    }

    public static String selectById(EntityMeta meta) {
        return "SELECT * FROM " + meta.tableName() + " WHERE " + meta.primaryKeyColumn() + " = ?;";
    }

    private static String sqlType(FieldMeta field) {
        FieldType t = field.fieldType();
        if (t == FieldType.STRING) {
            return SqlDialectUtil.varchar(field.maxLength());
        }
        if (t == FieldType.EMAIL) {
            return SqlDialectUtil.varchar(field.maxLength() > 0 ? field.maxLength() : 255);
        }
        if (t == FieldType.INT) {
            return "INT";
        }
        if (t == FieldType.LONG) {
            return "BIGINT";
        }
        if (t == FieldType.BOOLEAN) {
            return "BOOLEAN";
        }
        if (t == FieldType.DECIMAL) {
            return "DECIMAL(18,6)";
        }
        if (t == FieldType.TIMESTAMP) {
            return "TIMESTAMP";
        }
        if (t == FieldType.DATE) {
            return "DATE";
        }
        if (t == FieldType.JSON) {
            return "JSON";
        }
        if (t == FieldType.ENCRYPTED) {
            return SqlDialectUtil.varchar(field.maxLength() > 0 ? field.maxLength() : 512);
        }
        return "TEXT";
    }

    private static String varchar(int len) {
        if (len > 0) {
            return "VARCHAR(" + len + ")";
        }
        return "VARCHAR(255)";
    }
}

