/*
 * Decompiled with CFR 0.152.
 */
package de.syntaxjason.database;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import de.syntaxjason.core.ConnectionRegistry;
import de.syntaxjason.core.DatabaseConfig;
import de.syntaxjason.core.EntityManager;
import de.syntaxjason.crypto.CryptoRegistry;
import de.syntaxjason.crypto.CryptoService;
import de.syntaxjason.types.DatabaseType;
import de.syntaxjason.validation.ValidatorRegistry;
import de.syntaxjason.validation.ValidatorService;

public class QueryLib {
    private QueryLib() {
    }

    public static HikariDataSource hikari(String jdbcUrl, String user, String password) {
        String dbType;
        HikariConfig cfg = new HikariConfig();
        cfg.setJdbcUrl(jdbcUrl);
        switch (dbType = jdbcUrl.split(":")[1]) {
            case "mongo": {
                cfg.setDriverClassName("com.mongodb.MongoClientDriver");
                break;
            }
            case "sqlite": {
                cfg.setDriverClassName("org.sqlite.JDBC");
                break;
            }
            case "postgres": {
                cfg.setDriverClassName("org.postgresql.Driver");
                break;
            }
            case "mysql": {
                cfg.setDriverClassName("com.mysql.cj.jdbc.Driver");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown database type: " + dbType);
            }
        }
        if (user != null) {
            cfg.setUsername(user);
        }
        if (password != null) {
            cfg.setPassword(password);
        }
        cfg.setMaximumPoolSize(10);
        return new HikariDataSource(cfg);
    }

    public static void registerMySql(String url, String user, String password) {
        HikariDataSource ds = QueryLib.hikari(url, user, password);
        ConnectionRegistry.register(DatabaseConfig.forJdbc(DatabaseType.MYSQL, ds));
    }

    public static void registerPostgres(String url, String user, String password) {
        HikariDataSource ds = QueryLib.hikari(url, user, password);
        ConnectionRegistry.register(DatabaseConfig.forJdbc(DatabaseType.POSTGRESQL, ds));
    }

    public static void registerSqlite(String fileUrl) {
        HikariDataSource ds = QueryLib.hikari(fileUrl, null, null);
        ConnectionRegistry.register(DatabaseConfig.forJdbc(DatabaseType.SQLITE, ds));
    }

    public static void registerMongo(String connectionString, String database) {
        MongoClient client = MongoClients.create((String)connectionString);
        ConnectionRegistry.register(DatabaseConfig.forMongo(client, database));
    }

    public static void registerEntities(Class<?> ... entities) {
        for (Class<?> entity : entities) {
            EntityManager.registerEntity(entity);
        }
    }

    public static void setCryptoService(CryptoService cryptoService) {
        CryptoRegistry.setCryptoService(cryptoService);
    }

    public static void setValidator(ValidatorService validatorService) {
        ValidatorRegistry.setValidator(validatorService);
    }
}

