/*
 * Decompiled with CFR 0.152.
 */
package de.syntaxjason.crypto;

import de.syntaxjason.crypto.CryptoService;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.SecureRandom;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public final class AesGcmCryptoService
implements CryptoService {
    private static final String ALGO = "AES";
    private static final String TRANSFORMATION = "AES/GCM/NoPadding";
    private static final int TAG_BITS = 128;
    private static final int IV_BYTES = 12;
    private final SecretKeySpec keySpec;
    private final SecureRandom random;

    public AesGcmCryptoService(byte[] key) {
        if (key == null || key.length != 16 && key.length != 24 && key.length != 32) {
            throw new IllegalArgumentException("AES key length must be 16, 24 or 32 bytes");
        }
        this.keySpec = new SecretKeySpec(key, ALGO);
        this.random = new SecureRandom();
    }

    @Override
    public String encrypt(String plainText) {
        if (plainText == null) {
            return null;
        }
        try {
            byte[] iv = new byte[12];
            this.random.nextBytes(iv);
            Cipher cipher = Cipher.getInstance(TRANSFORMATION);
            cipher.init(1, (Key)this.keySpec, new GCMParameterSpec(128, iv));
            byte[] cipherBytes = cipher.doFinal(plainText.getBytes(StandardCharsets.UTF_8));
            ByteBuffer buffer = ByteBuffer.allocate(12 + cipherBytes.length);
            buffer.put(iv).put(cipherBytes);
            return Base64.getEncoder().encodeToString(buffer.array());
        }
        catch (Exception e) {
            throw new RuntimeException("Encryption failed", e);
        }
    }

    @Override
    public String decrypt(String cipherText) {
        if (cipherText == null) {
            return null;
        }
        try {
            byte[] all = Base64.getDecoder().decode(cipherText);
            ByteBuffer buffer = ByteBuffer.wrap(all);
            byte[] iv = new byte[12];
            buffer.get(iv);
            byte[] cipherBytes = new byte[buffer.remaining()];
            buffer.get(cipherBytes);
            Cipher cipher = Cipher.getInstance(TRANSFORMATION);
            cipher.init(2, (Key)this.keySpec, new GCMParameterSpec(128, iv));
            byte[] plain = cipher.doFinal(cipherBytes);
            return new String(plain, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new RuntimeException("Decryption failed", e);
        }
    }
}

