/*
 * Decompiled with CFR 0.152.
 */
package de.syntaxjason.core;

import de.syntaxjason.adapter.JdbcAdapter;
import de.syntaxjason.adapter.MongoAdapter;
import de.syntaxjason.adapter.PersistenceAdapter;
import de.syntaxjason.cache.EntityCache;
import de.syntaxjason.core.ConnectionRegistry;
import de.syntaxjason.core.DatabaseConfig;
import de.syntaxjason.dialect.MySqlDialect;
import de.syntaxjason.dialect.PostgresDialect;
import de.syntaxjason.dialect.SqliteDialect;
import de.syntaxjason.meta.EntityMeta;
import de.syntaxjason.types.CacheStrategy;
import de.syntaxjason.types.DatabaseType;
import de.syntaxjason.validation.ValidatorRegistry;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public final class EntityManager {
    private static final Map<Class<?>, EntityMeta> METADATA = new ConcurrentHashMap();
    private static final Map<Class<?>, PersistenceAdapter> ADAPTERS = new ConcurrentHashMap();
    private static final Map<Class<?>, EntityCache<Object, Object>> CACHES = new ConcurrentHashMap();

    private EntityManager() {
    }

    public static EntityMeta meta(Class<?> type) {
        EntityMeta meta = METADATA.get(type);
        if (meta != null) {
            return meta;
        }
        EntityMeta built = EntityMeta.fromClass(type);
        METADATA.put(type, built);
        return built;
    }

    public static void registerEntity(Class<?> type) {
        EntityMeta entityMeta = EntityManager.meta(type);
        PersistenceAdapter adapter = EntityManager.resolveAdapter(entityMeta);
        ADAPTERS.put(type, adapter);
        CACHES.put(type, EntityManager.chooseCache(entityMeta));
        adapter.ensureSchema(entityMeta);
        adapter.ensureIndexes(entityMeta);
    }

    public static PersistenceAdapter adapter(Class<?> type) {
        PersistenceAdapter adapter = ADAPTERS.get(type);
        if (adapter != null) {
            return adapter;
        }
        EntityManager.registerEntity(type);
        return ADAPTERS.get(type);
    }

    private static PersistenceAdapter resolveAdapter(EntityMeta meta) {
        HashSet<DatabaseType> available = new HashSet<DatabaseType>();
        for (DatabaseType t : DatabaseType.values()) {
            if (!ConnectionRegistry.has(t)) continue;
            available.add(t);
        }
        for (DatabaseType t : meta.supportedTypes()) {
            DatabaseConfig cfg;
            if (!available.contains((Object)t)) continue;
            if (t == DatabaseType.MONGODB) {
                cfg = ConnectionRegistry.require(DatabaseType.MONGODB);
                return new MongoAdapter(cfg.mongoClient(), cfg.defaultDatabase());
            }
            cfg = ConnectionRegistry.require(t);
            if (t == DatabaseType.MYSQL) {
                return new JdbcAdapter(cfg.dataSource(), new MySqlDialect());
            }
            if (t == DatabaseType.POSTGRESQL) {
                return new JdbcAdapter(cfg.dataSource(), new PostgresDialect());
            }
            if (t != DatabaseType.SQLITE) continue;
            return new JdbcAdapter(cfg.dataSource(), new SqliteDialect());
        }
        throw new IllegalStateException("No available adapter for " + meta.type().getName());
    }

    private static EntityCache<Object, Object> chooseCache(EntityMeta meta) {
        if (meta.cacheStrategy() == CacheStrategy.NONE) {
            return EntityCache.none();
        }
        return EntityCache.local();
    }

    public static <T> Optional<T> findById(Class<T> type, Object id) {
        Optional<Object> hit;
        EntityMeta meta = EntityManager.meta(type);
        EntityCache<Object, Object> cache = CACHES.get(type);
        if (cache != null && id != null && (hit = cache.get(id)).isPresent()) {
            return hit;
        }
        PersistenceAdapter adapter = EntityManager.adapter(type);
        Optional<T> found = adapter.findById(meta, id, type);
        if (found.isPresent() && cache != null && id != null) {
            cache.put(id, found.get());
        }
        return found;
    }

    public static boolean save(Object entity) {
        EntityMeta meta = EntityManager.meta(entity.getClass());
        ValidatorRegistry.getValidator().validate(entity, meta);
        return EntityManager.adapter(entity.getClass()).insert(meta, entity);
    }

    public static boolean update(Object entity) {
        EntityMeta meta = EntityManager.meta(entity.getClass());
        ValidatorRegistry.getValidator().validate(entity, meta);
        return EntityManager.adapter(entity.getClass()).update(meta, entity);
    }

    public static boolean delete(Object entity) {
        EntityMeta meta = EntityManager.meta(entity.getClass());
        boolean ok = EntityManager.adapter(entity.getClass()).delete(meta, entity);
        if (!ok) {
            return false;
        }
        Object id = meta.primaryKeyField().getter().apply(entity);
        EntityCache<Object, Object> cache = CACHES.get(entity.getClass());
        if (cache != null && id != null) {
            cache.remove(id);
        }
        return true;
    }
}

