/*
 * Decompiled with CFR 0.152.
 */
package de.syntaxjason.core;

import com.mongodb.client.MongoClient;
import com.zaxxer.hikari.HikariDataSource;
import de.syntaxjason.types.DatabaseType;

public final class DatabaseConfig {
    private final DatabaseType type;
    private final HikariDataSource dataSource;
    private final MongoClient mongoClient;
    private final String defaultDatabase;

    private DatabaseConfig(DatabaseType type, HikariDataSource dataSource, MongoClient mongoClient, String defaultDatabase) {
        this.type = type;
        this.dataSource = dataSource;
        this.mongoClient = mongoClient;
        this.defaultDatabase = defaultDatabase;
    }

    public static DatabaseConfig forJdbc(DatabaseType type, HikariDataSource dataSource) {
        if (type == DatabaseType.MONGODB) {
            throw new IllegalArgumentException("Use forMongo for MongoDB configurations");
        }
        return new DatabaseConfig(type, dataSource, null, null);
    }

    public static DatabaseConfig forMongo(MongoClient client, String databaseName) {
        if (databaseName == null || databaseName.isBlank()) {
            throw new IllegalArgumentException("Mongo database name must not be blank");
        }
        return new DatabaseConfig(DatabaseType.MONGODB, null, client, databaseName);
    }

    public DatabaseType type() {
        return this.type;
    }

    public HikariDataSource dataSource() {
        return this.dataSource;
    }

    public MongoClient mongoClient() {
        return this.mongoClient;
    }

    public String defaultDatabase() {
        return this.defaultDatabase;
    }
}

