/*
 * Decompiled with CFR 0.152.
 */
package de.syntaxjason.core;

import de.syntaxjason.core.DatabaseConfig;
import de.syntaxjason.types.DatabaseType;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class ConnectionRegistry {
    private static final Map<DatabaseType, DatabaseConfig> REGISTRY = new ConcurrentHashMap<DatabaseType, DatabaseConfig>();

    private ConnectionRegistry() {
    }

    public static void register(DatabaseConfig config) {
        if (config == null) {
            throw new IllegalArgumentException("DatabaseConfig must not be null");
        }
        REGISTRY.put(config.type(), config);
    }

    public static DatabaseConfig require(DatabaseType type) {
        DatabaseConfig config = REGISTRY.get((Object)type);
        if (config != null) {
            return config;
        }
        throw new IllegalStateException("No configuration registered for " + String.valueOf((Object)type));
    }

    public static boolean has(DatabaseType type) {
        return REGISTRY.containsKey((Object)type);
    }
}

