/*
 * Decompiled with CFR 0.152.
 */
package de.syntaxjason.cache;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public interface EntityCache<ID, T> {
    public Optional<T> get(ID var1);

    public void put(ID var1, T var2);

    public void remove(ID var1);

    public static <ID, T> EntityCache<ID, T> none() {
        return new NoopCache();
    }

    public static <ID, T> EntityCache<ID, T> local() {
        return new LocalCache();
    }

    public static final class NoopCache<ID, T>
    implements EntityCache<ID, T> {
        @Override
        public Optional<T> get(ID id) {
            return Optional.empty();
        }

        @Override
        public void put(ID id, T value) {
        }

        @Override
        public void remove(ID id) {
        }
    }

    public static final class LocalCache<ID, T>
    implements EntityCache<ID, T> {
        private final Map<ID, T> storage = new ConcurrentHashMap<ID, T>();

        @Override
        public Optional<T> get(ID id) {
            return Optional.ofNullable(this.storage.get(id));
        }

        @Override
        public void put(ID id, T value) {
            this.storage.put(id, value);
        }

        @Override
        public void remove(ID id) {
            this.storage.remove(id);
        }
    }
}

