/*
 * Decompiled with CFR 0.152.
 */
package de.syntaxjason.adapter;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.result.DeleteResult;
import de.syntaxjason.adapter.PersistenceAdapter;
import de.syntaxjason.mapper.DocumentMapper;
import de.syntaxjason.meta.EntityMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.bson.Document;
import org.bson.conversions.Bson;

public final class MongoAdapter
implements PersistenceAdapter {
    private final MongoClient client;
    private final String databaseName;
    private final DocumentMapper documentMapper;

    public MongoAdapter(MongoClient client, String databaseName) {
        this.client = client;
        this.databaseName = databaseName;
        this.documentMapper = new DocumentMapper();
    }

    @Override
    public boolean insert(EntityMeta meta, Object entity) {
        MongoCollection<Document> collection = this.collection(meta);
        Document document = this.documentMapper.toDocument(meta, entity);
        collection.insertOne((Object)document);
        Object id = document.get((Object)"_id");
        if (id != null) {
            meta.primaryKeyField().setter().accept(entity, id);
        }
        return true;
    }

    @Override
    public boolean update(EntityMeta meta, Object entity) {
        MongoCollection<Document> collection = this.collection(meta);
        Object id = meta.primaryKeyField().getter().apply(entity);
        if (id == null) {
            throw new IllegalStateException("ID required for update");
        }
        Document document = this.documentMapper.toDocument(meta, entity);
        collection.replaceOne((Bson)new Document("_id", id), (Object)document);
        return true;
    }

    @Override
    public boolean delete(EntityMeta meta, Object entity) {
        MongoCollection<Document> collection = this.collection(meta);
        Object id = meta.primaryKeyField().getter().apply(entity);
        if (id == null) {
            return false;
        }
        DeleteResult result = collection.deleteOne((Bson)new Document("_id", id));
        return result.getDeletedCount() > 0L;
    }

    @Override
    public <T> Optional<T> findById(EntityMeta meta, Object id, Class<T> type) {
        MongoCollection<Document> collection = this.collection(meta);
        Document document = (Document)collection.find((Bson)new Document("_id", id)).first();
        if (document == null) {
            return Optional.empty();
        }
        return Optional.of(this.documentMapper.fromDocument(document, meta, type));
    }

    @Override
    public <T> List<T> queryByFields(EntityMeta meta, Class<T> type, String[] columns, Object[] values) {
        MongoCollection<Document> collection = this.collection(meta);
        Document filter = new Document();
        if (columns != null && values != null) {
            for (int i = 0; i < Math.min(columns.length, values.length); ++i) {
                filter.append(columns[i], values[i]);
            }
        }
        ArrayList<T> result = new ArrayList<T>();
        for (Document doc : collection.find((Bson)filter)) {
            result.add(this.documentMapper.fromDocument(doc, meta, type));
        }
        return result;
    }

    @Override
    public <T> List<T> findAll(EntityMeta meta, Class<T> type) {
        MongoCollection<Document> collection = this.collection(meta);
        ArrayList<T> result = new ArrayList<T>();
        for (Document doc : collection.find()) {
            result.add(this.documentMapper.fromDocument(doc, meta, type));
        }
        return result;
    }

    @Override
    public void ensureSchema(EntityMeta meta) {
        this.collection(meta);
    }

    @Override
    public void ensureIndexes(EntityMeta meta) {
        MongoCollection<Document> collection = this.collection(meta);
        meta.indexes().forEach(idx -> {
            Document keys = new Document();
            for (String field : idx.fields()) {
                keys.append(field, (Object)1);
            }
            IndexOptions options = new IndexOptions().unique(idx.unique()).name(idx.name());
            collection.createIndex((Bson)keys, options);
        });
    }

    private MongoCollection<Document> collection(EntityMeta meta) {
        MongoDatabase db = this.client.getDatabase(this.databaseName);
        return db.getCollection(meta.tableName());
    }
}

